#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays
set -o errexit

###
# Duet
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250707.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='duet'
GAME_NAME='Duet'

## This DRM-free build is no longer available for sale from humblebundle.com.
ARCHIVE_BASE_0_NAME='Duet-Build1006023-Linux64.zip'
ARCHIVE_BASE_0_MD5='b9c34c29da94c199ee75a5e71272a1eb'
ARCHIVE_BASE_0_SIZE='210000'
ARCHIVE_BASE_0_VERSION='1.0-humble1006023'

ARCHIVE_OPTIONAL_ICONS_NAME='duet_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5='57d79a524801768a742405a7a5310e08'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/duet/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
128x128
256x256'

CONTENT_PATH_DEFAULT='.'
CONTENT_LIBS_BIN_FILES='
libsfml-audio.so.2.3
libsfml-graphics.so.2.3
libsfml-system.so.2.3
libsfml-window.so.2.3'
## The game binary is linked against libsteam_api.so, so it can not be dropped.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libsteam_api.so"
CONTENT_LIBS0_BIN_PATH='steam-runtime/amd64/usr/lib/x86_64-linux-gnu'
CONTENT_LIBS0_BIN_FILES='
libjpeg.so.8
libjpeg.so.8.0.2'
CONTENT_GAME_BIN_FILES='
Duet'
CONTENT_GAME_DATA_FILES='
Media'

APP_MAIN_EXE='Duet'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libFLAC.so.8
libfreetype.so.6
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6
libudev.so.0
libvorbisenc.so.2
libvorbisfile.so.3
libvorbis.so.0
libX11.so.6
libX11-xcb.so.1
libxcb-randr.so.0
libxcb.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
