**See [OpenWrt Wiki: Get a free HTTPS certificate from LetsEncrypt for OpenWrt with ACME.sh](https://openwrt.org/docs/guide-user/services/tls/acmesh)**

Setup and run acme.sh on your [OpenWrt](https://openwrt.org) router and have HTTPS secured management.

### Step 1: Install packages

`opkg install luci-ssl-openssl acme luci-app-acme`

If you want to use DNS-based certificate verification, also install the DNS providers:

`opkg install acme-acmesh-dnsapi`

If the above command doesn't work, try this command:

`opkg install acme-dnsapi`

### Step 2: Configure Web Server
Here we'll tell uhttpd redirect to HTTPS.

These commands use the OpenWrt [`uci` command](https://wiki.openwrt.org/doc/uci), a brilliant way to parse, get, set, and edit values and sections from config files. It makes scripting OpenWrt a breeze.

```
uci set uhttpd.main.redirect_https=1
uci commit uhttpd
/etc/init.d/uhttpd restart
```

### Step 3: Configure acme.sh and get your certificate
On your router:

Navigate to `Services -> ACME certs` in LuCI and configure your certificate details. Make sure you made it `Enabled` for your configured certificate.

For old versions you may also need to select `Use for uhttpd`. This option was removed in newer versions and all dependant services must setup their own hotplug hook scripts to restart themselves.

If you prefer to use the command line, simply edit `/etc/config/acme`, and run `/etc/init.d/acme start` afterwards.

### Step 4: Configure Firewall
Open or forward LuCI port for external access. (use Webinterface)
