Macedonian and English (`apertium-mk-en`)
===============================================================================

This is an Apertium language pair for translating from Macedonian to
English. What you can use this language package for:

* Translating from Macedonian to English
* Morphological analysis of Macedonian
* Part-of-speech tagging of Macedonian

For information on the latter two points, see subheading "For more 
information" below

Requirements
===============================================================================

You will need the following software installed:

* lttoolbox (>= 3.1.2)
* apertium (>= 3.1.1)
* vislcg3 (>= 0.9.7.5129)

If this does not make any sense, we recommend you look at: apertium.org

Compiling
===============================================================================

Given the requirements being installed, you should be able to just run:
```
$ ./configure 
$ make
```
You can use `./autogen.sh` instead of `./configure` you're compiling from
SVN. If you're using a `--prefix` to `./configure`, make sure it's the
same one you used to install apertium itself.

Testing
===============================================================================

If you are in the source directory after running make, the following
commands should work:
```
$  echo "Јас сум тука." | apertium -d . mk-en
I am here.
```
After installing somewhere in $PATH, you should be able to do eg.
```
$  echo "Јас сум тука." | apertium mk-en
I am here.
```
The following command runs tests which are on the Apertium wiki page:
```
$ ./regression-tests.sh 
```

Files and data
===============================================================================

* `apertium-mk-en.mk.dix`            - Monolingual dictionary for Macedonian
* `apertium-mk-en.mk-en.dix`         - Bilingual dictionary 
* `apertium-mk-en.en.dix`            - Monolingual dictionary for English
* `apertium-mk-en.post-en.dix`       - Postgeneration dictionary for English
* `apertium-mk-en.mk-en.rlx`         - Constraint Grammar for Macedonian
* `apertium-mk-en.mk-en.t1x`         - Chunker rules for translating into English
* `apertium-mk-en.mk-en.t2x`         - Interchunk rules for translating into English
* `apertium-mk-en.mk-en.t3x`         - Postchunk rules for translating into English
* `mk-en.prob`                       - Tagger model for Macedonian
* `modes.xml`                        - Translation modes

For more information
===============================================================================

* https://wiki.apertium.org/wiki/Installation
* https://wiki.apertium.org/wiki/apertium-mk-en
* https://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary
* https://wiki.apertium.org/wiki/Constraint_Grammar

Help and support
===============================================================================

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: `#apertium` on `irc.oftc.net`

See also the file AUTHORS included in this distribution.
