/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.aspectj.internal.tools.build.BuildSpec;
import org.aspectj.internal.tools.build.Messager;
import org.aspectj.internal.tools.build.Module;
import org.aspectj.internal.tools.build.Modules;
import org.aspectj.internal.tools.build.ProductModule;
import org.aspectj.internal.tools.build.Result;
import org.aspectj.internal.tools.build.Util;

public abstract class Builder {
    public static final String RESOURCE_PATTERN;
    public static final String BINARY_SOURCE_PATTERN;
    public static final String ALL_PATTERN;
    protected static final boolean FILTER_ON = true;
    protected static final boolean FILTER_OFF = false;
    private static final String SKIP_LIBRARIES_KEY = "skip.libraries";
    private static final List SKIP_LIBRARIES;
    private static final String ERROR_KEY = "error loading properties";
    private static final Properties PROPS;
    protected final Messager handler;
    protected boolean buildingEnabled;
    private final File tempDir;
    private final ArrayList tempFiles;
    private final boolean useEclipseCompiles;
    protected boolean verbose;
    static /* synthetic */ Class class$org$aspectj$internal$tools$build$Builder;

    public static List commaStrings(String text) {
        if (null == text || 0 == text.length()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(text, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            if (0 >= token.length()) continue;
            strings.add(token);
        }
        return Collections.unmodifiableList(strings);
    }

    private String moduleAliasFor(String jarName) {
        String result = PROPS.getProperty("alias." + jarName, jarName);
        if (this.verbose && result.equals(jarName)) {
            String m = "expected alias for " + jarName;
            this.handler.error(m + PROPS.getProperty(ERROR_KEY, ""));
        }
        return result;
    }

    protected Builder(File tempDir, boolean useEclipseCompiles, Messager handler) {
        Util.iaxIfNull(handler, "handler");
        this.useEclipseCompiles = useEclipseCompiles;
        this.handler = handler;
        this.tempFiles = new ArrayList();
        this.tempDir = null == tempDir || !tempDir.canWrite() || !tempDir.isDirectory() ? Util.makeTempDir("Builder") : tempDir;
        this.buildingEnabled = true;
    }

    public void setBuildingEnabled(boolean enabled) {
        this.buildingEnabled = enabled;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void verifyBuildSpec(BuildSpec buildSpec) {
        if (null == buildSpec.productDir) {
            if (null == buildSpec.moduleDir) {
                if (null == buildSpec.baseDir) {
                    throw new BuildException("require baseDir or moduleDir");
                }
                if (null == buildSpec.module) {
                    throw new BuildException("require module with baseDir");
                }
                if (null == buildSpec.baseDir) {
                    buildSpec.baseDir = new File(".");
                }
                buildSpec.moduleDir = new File(buildSpec.baseDir, buildSpec.module);
            } else if (null == buildSpec.baseDir) {
                buildSpec.baseDir = buildSpec.moduleDir.getParentFile();
                if (null == buildSpec.baseDir) {
                    buildSpec.baseDir = new File(".");
                }
                this.handler.log("Builder using derived baseDir: " + buildSpec.baseDir);
            }
            Util.iaxIfNotCanReadDir(buildSpec.moduleDir, "moduleDir");
            if (null == buildSpec.module) {
                buildSpec.module = buildSpec.moduleDir.getName();
                if (null == buildSpec.module) {
                    throw new BuildException("no name, even from " + buildSpec.moduleDir);
                }
            }
        }
    }

    protected Result specifyResultFor(BuildSpec buildSpec) {
        if (buildSpec.trimTesting && -1 != buildSpec.module.indexOf("testing")) {
            String warning = "Warning - cannot trimTesting for testing modules: ";
            this.handler.log(warning + buildSpec.module);
        }
        Messager handler = new Messager();
        Modules modules = new Modules(buildSpec.baseDir, buildSpec.jarDir, handler);
        Module moduleToBuild = modules.getModule(buildSpec.module);
        Result.Kind kind = Result.kind(buildSpec.trimTesting, buildSpec.assembleAll);
        return moduleToBuild.getResult(kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean build(BuildSpec buildSpec) {
        boolean bl;
        block7: {
            Iterator iter2;
            String label2;
            if (!this.buildingEnabled) {
                return false;
            }
            this.verifyBuildSpec(buildSpec);
            if (null != buildSpec.productDir) {
                return this.buildProduct(buildSpec);
            }
            Result result = this.specifyResultFor(buildSpec);
            ArrayList errors = new ArrayList();
            try {
                bl = this.buildAll(result, errors);
                Object var6_5 = null;
                if (0 >= errors.size()) break block7;
                label2 = "error building " + buildSpec + ": ";
                iter2 = errors.iterator();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (0 < errors.size()) {
                    String label2 = "error building " + buildSpec + ": ";
                    Iterator iter2 = errors.iterator();
                    while (iter2.hasNext()) {
                        String m = label2 + iter2.next();
                        this.handler.error(m);
                    }
                }
                throw throwable;
            }
            while (iter2.hasNext()) {
                String m = label2 + iter2.next();
                this.handler.error(m);
            }
        }
        return bl;
    }

    public boolean cleanup() {
        boolean noErr = true;
        ListIterator iter = this.tempFiles.listIterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            if (Util.deleteContents(file) && file.delete()) continue;
            if (noErr) {
                noErr = false;
            }
            this.handler.log("unable to clean up " + file);
        }
        return noErr;
    }

    protected final boolean isLogging() {
        return this.verbose && null != this.handler;
    }

    protected Result[] skipUptodate(Result[] results) {
        if (null == results) {
            return new Result[0];
        }
        Result[] done = new Result[results.length];
        int to = 0;
        for (int i = 0; i < done.length; ++i) {
            if (null == results[i] || !results[i].outOfDate()) continue;
            done[to++] = results[i];
        }
        if (to < results.length) {
            Result[] newdone = new Result[to];
            System.arraycopy(done, 0, newdone, 0, newdone.length);
            done = newdone;
        }
        return done;
    }

    protected final boolean buildAll(Result result, List errors) {
        Result[] buildList = this.skipUptodate(this.getAntecedantResults(result));
        ArrayList<String> doneList = new ArrayList<String>();
        if (null != buildList && 0 < buildList.length) {
            if (this.isLogging()) {
                this.handler.log("modules to build: " + Arrays.asList(buildList));
            }
            for (int i = 0; i < buildList.length; ++i) {
                Result required = buildList[i];
                if (!this.buildingEnabled) {
                    return false;
                }
                String requiredName = required.getName();
                if (doneList.contains(requiredName)) continue;
                doneList.add(requiredName);
                if (this.buildOnly(required, errors)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean buildOnly(Result result, List errors) {
        boolean bl;
        File classesDir;
        if (!result.outOfDate()) {
            return true;
        }
        if (this.isLogging()) {
            this.handler.log("building " + result);
        }
        if (!this.buildingEnabled) {
            return false;
        }
        if (result.getKind().assemble) {
            return this.assembleAll(result, this.handler);
        }
        Module module = result.getModule();
        if (this.useEclipseCompiles) {
            classesDir = new File(module.moduleDir, "bin");
        } else {
            String name = "classes-" + System.currentTimeMillis();
            classesDir = new File(this.tempDir, name);
        }
        if (this.verbose) {
            this.handler.log("buildOnly " + module);
        }
        try {
            bl = this.compile(result, classesDir, this.useEclipseCompiles, errors) && this.assemble(result, classesDir, errors);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var7_8 = null;
                if (this.useEclipseCompiles || Util.delete(classesDir)) break block10;
                errors.add("buildOnly unable to delete " + classesDir);
            }
            throw throwable;
        }
        if (!this.useEclipseCompiles && !Util.delete(classesDir)) {
            errors.add("buildOnly unable to delete " + classesDir);
        }
        return bl;
    }

    protected void addTempFile(File tempFile) {
        if (null != tempFile) {
            this.tempFiles.add(tempFile);
        }
    }

    protected final boolean buildProduct(BuildSpec buildSpec) throws BuildException {
        Util.iaxIfNull(buildSpec, "buildSpec");
        if (!buildSpec.trimTesting) {
            buildSpec.trimTesting = true;
            this.handler.log("testing trimmed for " + buildSpec);
        }
        Util.iaxIfNotCanReadDir(buildSpec.productDir, "productDir");
        Util.iaxIfNotCanReadDir(buildSpec.baseDir, "baseDir");
        Util.iaxIfNotCanWriteDir(buildSpec.distDir, "distDir");
        Modules modules = new Modules(buildSpec.baseDir, buildSpec.jarDir, this.handler);
        ProductModule[] productModules = this.discoverModules(buildSpec.productDir, modules);
        for (int i = 0; i < productModules.length; ++i) {
            if (buildSpec.verbose) {
                this.handler.log("building product module " + productModules[i]);
            }
            if (this.buildProductModule(productModules[i])) continue;
            return false;
        }
        if (buildSpec.verbose) {
            this.handler.log("assembling product module for " + buildSpec);
        }
        String productName = buildSpec.productDir.getName();
        File targDir = new File(buildSpec.distDir, productName);
        String targDirPath = targDir.getPath();
        if (targDir.canWrite()) {
            Util.deleteContents(targDir);
        }
        if (!targDir.canWrite() && !targDir.mkdirs()) {
            if (buildSpec.verbose) {
                this.handler.log("buildProduct unable to create " + targDir);
            }
            return false;
        }
        File distDir = new File(buildSpec.productDir, "dist");
        if (!this.copyNonBinaries(buildSpec, distDir, targDir)) {
            return false;
        }
        String excludes = null;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < productModules.length; ++i) {
            if (0 < buf.length()) {
                buf.append(",");
            }
            buf.append(productModules[i].relativePath);
        }
        if (0 < buf.length()) {
            excludes = buf.toString();
        }
        if (!this.copyBinaries(buildSpec, distDir, targDir, excludes)) {
            return false;
        }
        for (int i = 0; i < productModules.length; ++i) {
            ProductModule product = productModules[i];
            Result.Kind kind = Result.kind(true, product.assembleAll);
            Result result = product.module.getResult(kind);
            String targPath = Util.path(targDirPath, product.relativePath);
            File jarFile = result.getOutputFile();
            this.copyFile(jarFile, new File(targPath), false);
        }
        this.handler.log("created product in " + targDir);
        if (buildSpec.createInstaller) {
            return this.buildInstaller(buildSpec, targDirPath);
        }
        return true;
    }

    protected boolean copyBinaries(BuildSpec buildSpec, File distDir, File targDir, String excludes) {
        String includes = BINARY_SOURCE_PATTERN;
        return this.copyFiles(distDir, targDir, includes, excludes, false);
    }

    protected boolean copyNonBinaries(BuildSpec buildSpec, File distDir, File targDir) {
        String excludes = BINARY_SOURCE_PATTERN;
        String includes = ALL_PATTERN;
        return this.copyFiles(distDir, targDir, includes, excludes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean buildProductModule(ProductModule module) {
        Iterator iter2;
        boolean bl;
        ArrayList errors = new ArrayList();
        try {
            Result.Kind productKind = Result.kind(true, true);
            Result result = module.module.getResult(productKind);
            bl = this.buildAll(result, errors);
            Object var7_6 = null;
            iter2 = errors.iterator();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Iterator iter2 = errors.iterator();
            while (iter2.hasNext()) {
                this.handler.error("error building " + module + ": " + iter2.next());
            }
            throw throwable;
        }
        while (iter2.hasNext()) {
            this.handler.error("error building " + module + ": " + iter2.next());
        }
        return bl;
    }

    protected ProductModule[] discoverModules(File productDir, Modules modules) {
        final ArrayList found = new ArrayList();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                if (null != file && file.canRead() && file.getPath().endsWith(".jar") && 0L == file.length()) {
                    found.add(file);
                }
                return true;
            }
        };
        Util.visitFiles(productDir, filter);
        ArrayList<ProductModule> results = new ArrayList<ProductModule>();
        Iterator iter = found.iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            String jarName = this.moduleAliasFor(file.getName().toLowerCase());
            if (jarName.endsWith(".jar") || jarName.endsWith(".zip")) {
                jarName = jarName.substring(0, jarName.length() - 4);
            } else {
                this.handler.log("can only replace .[jar|zip]: " + file);
            }
            boolean assembleAll = jarName.endsWith("-all");
            String name = !assembleAll ? jarName : jarName.substring(0, jarName.length() - 4);
            Module module = modules.getModule(name);
            if (null == module) {
                this.handler.log("unable to find module for " + file);
                continue;
            }
            results.add(new ProductModule(productDir, file, module, assembleAll));
        }
        return results.toArray(new ProductModule[0]);
    }

    protected void removeLibraryFilesToSkip(Module module, List libraries) {
        ListIterator liter = libraries.listIterator();
        block0: while (liter.hasNext()) {
            File library = (File)liter.next();
            String fname = library.getName();
            if (null == fname) continue;
            Iterator iter = SKIP_LIBRARIES.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (!fname.equals(name)) continue;
                liter.remove();
                continue block0;
            }
        }
    }

    protected abstract Result[] getAntecedantResults(Result var1);

    protected abstract boolean compile(Result var1, File var2, boolean var3, List var4);

    protected abstract boolean assemble(Result var1, File var2, List var3);

    protected abstract boolean assembleAll(Result var1, Messager var2);

    protected abstract boolean buildInstaller(BuildSpec var1, String var2);

    protected abstract boolean copyFile(File var1, File var2, boolean var3);

    protected abstract boolean copyFiles(File var1, File var2, String var3, String var4, boolean var5);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROPS = new Properties();
        List skips = Collections.EMPTY_LIST;
        String resourcePattern = "**/*.txt,**/*.rsc,**/*.gif,**/*.properties";
        String allPattern = "**/*";
        String binarySourcePattern = "**/*.rsc,**/*.gif,**/*.jar,**/*.zip";
        String name = (class$org$aspectj$internal$tools$build$Builder == null ? (class$org$aspectj$internal$tools$build$Builder = Builder.class$("org.aspectj.internal.tools.build.Builder")) : class$org$aspectj$internal$tools$build$Builder).getName().replace('.', '/') + ".properties";
        try {
            InputStream in = (class$org$aspectj$internal$tools$build$Builder == null ? (class$org$aspectj$internal$tools$build$Builder = Builder.class$("org.aspectj.internal.tools.build.Builder")) : class$org$aspectj$internal$tools$build$Builder).getClassLoader().getResourceAsStream(name);
            PROPS.load(in);
            allPattern = PROPS.getProperty("all.pattern");
            resourcePattern = PROPS.getProperty("resource.pattern");
            binarySourcePattern = PROPS.getProperty("binarySource.pattern");
            skips = Builder.commaStrings(PROPS.getProperty(SKIP_LIBRARIES_KEY));
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            String m = "error loading " + name + ": " + t.getClass() + " " + t;
            PROPS.setProperty(ERROR_KEY, m);
        }
        SKIP_LIBRARIES = skips;
        ALL_PATTERN = allPattern;
        BINARY_SOURCE_PATTERN = binarySourcePattern;
        RESOURCE_PATTERN = resourcePattern;
    }
}

