{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FWireframeColorPersistent: TCastleColorRGBPersistent;
  function GetWireframeColorForPersistent: TCastleColorRGB;
  procedure SetWireframeColorForPersistent(const AValue: TCastleColorRGB);
published
  { @link(WireframeColor) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(WireframeColor) directly.

    @seealso WireframeColor }
  property WireframeColorPersistent: TCastleColorRGBPersistent read FWireframeColorPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleRenderOptions.GetWireframeColorForPersistent: TCastleColorRGB;
begin
  Result := WireframeColor;
end;

procedure TCastleRenderOptions.SetWireframeColorForPersistent(const AValue: TCastleColorRGB);
begin
  WireframeColor := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FWireframeColorPersistent := TCastleColorRGBPersistent.Create;
  FWireframeColorPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetWireframeColorForPersistent;
  FWireframeColorPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetWireframeColorForPersistent;
  FWireframeColorPersistent.InternalDefaultValue := WireframeColor; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FWireframeColorPersistent);
{$endif read_implementation_destructor}

