{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdCoordIndex: TMFLong;
    { Internal wrapper for property @link(CoordIndex). This wrapper API may change, we advise to access simpler @link(CoordIndex) instead. }
    public property FdCoordIndex: TMFLong read FFdCoordIndex;

    strict private FFdMaterialIndex: TMFLong;
    { Internal wrapper for property @link(MaterialIndex). This wrapper API may change, we advise to access simpler @link(MaterialIndex) instead. }
    public property FdMaterialIndex: TMFLong read FFdMaterialIndex;

    strict private FFdNormalIndex: TMFLong;
    { Internal wrapper for property @link(NormalIndex). This wrapper API may change, we advise to access simpler @link(NormalIndex) instead. }
    public property FdNormalIndex: TMFLong read FFdNormalIndex;

    strict private FFdTextureCoordIndex: TMFLong;
    { Internal wrapper for property @link(TextureCoordIndex). This wrapper API may change, we advise to access simpler @link(TextureCoordIndex) instead. }
    public property FdTextureCoordIndex: TMFLong read FFdTextureCoordIndex;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractIndexedNode_1 ----------------------------------------------- }

class function TAbstractIndexedNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TAbstractIndexedNode_1.ClassX3DType: String;
begin
  Result := 'AbstractVrml1Indexed';
end;

procedure TAbstractIndexedNode_1.CreateNode;
begin
  inherited;

  FFdCoordIndex := TMFLong.Create(Self, True, 'coordIndex', [0]);
   FdCoordIndex.ChangeAlways := chGeometry;
  AddField(FFdCoordIndex);

  FFdMaterialIndex := TMFLong.Create(Self, True, 'materialIndex', [-1]);
   FdMaterialIndex.ChangeAlways := chGeometry;
  AddField(FFdMaterialIndex);

  FFdNormalIndex := TMFLong.Create(Self, True, 'normalIndex', [-1]);
   FdNormalIndex.ChangeAlways := chGeometry;
  AddField(FFdNormalIndex);

  FFdTextureCoordIndex := TMFLong.Create(Self, True, 'textureCoordIndex', [-1]);
   FdTextureCoordIndex.ChangeAlways := chGeometry;
  AddField(FFdTextureCoordIndex);
end;

{$endif read_implementation}
