{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetGeometry: TAbstractGeometryNode;
    procedure SetGeometry(const Value: TAbstractGeometryNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdGeometry: TSFNode;
    { Internal wrapper for property @link(Geometry). This wrapper API may change, we advise to access simpler @link(Geometry) instead. }
    public property FdGeometry: TSFNode read FFdGeometry;
    {  }
    property Geometry: TAbstractGeometryNode read GetGeometry write SetGeometry;

{$endif read_interface}

{$ifdef read_implementation}

{ TBoundedPhysicsModelNode ----------------------------------------------- }

function TBoundedPhysicsModelNode.GetGeometry: TAbstractGeometryNode;
begin
  if FdGeometry.Value is TAbstractGeometryNode then
    Result := TAbstractGeometryNode(FdGeometry.Value)
  else
    Result := nil;
end;

procedure TBoundedPhysicsModelNode.SetGeometry(const Value: TAbstractGeometryNode);
begin
  FdGeometry.Send(Value);
end;

class function TBoundedPhysicsModelNode.ClassX3DType: String;
begin
  Result := 'BoundedPhysicsModel';
end;

procedure TBoundedPhysicsModelNode.CreateNode;
begin
  inherited;

  FFdGeometry := TSFNode.Create(Self, True, 'geometry', [TAbstractGeometryNode]);
   FdGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeometry);
end;

{$endif read_implementation}
