{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAngle: Single;
    procedure SetAngle(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdAxis: TSFEnum;
    { Internal wrapper for property @link(Axis). This wrapper API may change, we advise to access simpler @link(Axis) instead. }
    public property FdAxis: TSFEnum read FFdAxis;

    strict private FFdAngle: TSFFloat;
    { Internal wrapper for property @link(Angle). This wrapper API may change, we advise to access simpler @link(Angle) instead. }
    public property FdAngle: TSFFloat read FFdAngle;
    {  }
    property Angle: Single read GetAngle write SetAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TRotationXYZNode_1 ----------------------------------------------- }

function TRotationXYZNode_1.GetAngle: Single;
begin
  Result := FdAngle.Value;
end;

procedure TRotationXYZNode_1.SetAngle(const Value: Single);
begin
  FdAngle.Send(Value);
end;

class function TRotationXYZNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TRotationXYZNode_1.ClassX3DType: String;
begin
  Result := 'RotationXYZ';
end;

procedure TRotationXYZNode_1.CreateNode;
begin
  inherited;

  FFdAxis := TSFEnum.Create(Self, True, 'axis', @AxisNames, Ord(High(AxisNames)) + 1, 0);
   FdAxis.ChangeAlways := chEverything;
  AddField(FFdAxis);

  FFdAngle := TSFFloat.Create(Self, True, 'angle', 0);
   FdAngle.ChangeAlways := chEverything;
   FdAngle.Angle := true;
  AddField(FFdAngle);
end;

{$endif read_implementation}
