{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdTargetObject: TSFNode;
    { Internal wrapper for property @link(TargetObject). This wrapper API may change, we advise to access simpler @link(TargetObject) instead. }
    public property FdTargetObject: TSFNode read FFdTargetObject;

    strict private FEventOrientation_changed: TSFRotationEvent;
    {  }
    public property EventOrientation_changed: TSFRotationEvent read FEventOrientation_changed;

    strict private FEventPosition_changed: TSFVec3fEvent;
    {  }
    public property EventPosition_changed: TSFVec3fEvent read FEventPosition_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TTransformSensorNode ----------------------------------------------- }

class function TTransformSensorNode.ClassX3DType: String;
begin
  Result := 'TransformSensor';
end;

procedure TTransformSensorNode.CreateNode;
begin
  inherited;

  FFdTargetObject := TSFNode.Create(Self, True, 'targetObject', [TAbstractGroupingNode, TAbstractShapeNode]);
   FdTargetObject.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTargetObject);

  FEventOrientation_changed := TSFRotationEvent.Create(Self, 'orientation_changed', false);
  AddEvent(FEventOrientation_changed);

  FEventPosition_changed := TSFVec3fEvent.Create(Self, 'position_changed', false);
  AddEvent(FEventPosition_changed);
end;

{$endif read_implementation}
