//##########################################################################
//#                                                                        #
//#                              CLOUDCOMPARE                              #
//#                                                                        #
//#  This program is free software; you can redistribute it and/or modify  #
//#  it under the terms of the GNU General Public License as published by  #
//#  the Free Software Foundation; version 2 or later of the License.      #
//#                                                                        #
//#  This program is distributed in the hope that it will be useful,       #
//#  but WITHOUT ANY WARRANTY; without even the implied warranty of        #
//#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          #
//#  GNU General Public License for more details.                          #
//#                                                                        #
//#          COPYRIGHT: EDF R&D / TELECOM ParisTech (ENST-TSI)             #
//#                                                                        #
//##########################################################################

#ifndef CC_LAS_OPEN_DIALOG
#define CC_LAS_OPEN_DIALOG

//Local
#include "LASFields.h"

//GUIs generated by Qt Designer
#include <ui_openLASFileDlg.h>

//system
#include <string.h>
#include <vector>

//CCLib
#include <CCGeom.h>

//! Dialog to choose the LAS fields to load
class LASOpenDlg : public QDialog, public Ui::OpenLASFileDialog
{
	Q_OBJECT

public:

	//! Default constructor
	explicit LASOpenDlg(QWidget* parent = 0);

	//! Sets available dimensions
	void setDimensions(const std::vector<std::string>& dimensions);

	//! Whether to load a given field
	bool doLoad(LAS_FIELDS field) const;

	//! Clears the 'extra bytes' record
	void clearEVLRs();

	//! Sets the information about the file
	void setInfos(	QString filename,
					unsigned pointCount,
					const CCVector3d& bbMin,
					const CCVector3d& bbMax);

	//! Adds an 'extra bytes' record entry
	void addEVLR(QString description);

	//! Returns whether an EVLR is selected for laoding or not
	bool doLoadEVLR(size_t index) const;

	//! Auto-skip mode (to use the same parameters for ALL files afterwards)
	inline bool autoSkipMode() const { return m_autoSkip; }

	//! Whether 8-bit RGB mode is forced or not
	bool forced8bitRgbMode() const;

	//! Resets the "apply all" flag (if set)
	void resetApplyAll();

protected slots:

	void onApplyAll();
	void onBrowse();

protected:

	bool m_autoSkip;
};

#endif //CC_LAS_OPEN_DIALOG
