#ifndef _UDPINPUT_H
#define _UDPINPUT_H 1

#include <mutex>
#include <string>
#include <vector>

#include "input.h"

class InputProto;

class UDPInput : public Input {
public:
	UDPInput(const std::string &url);

	// Serialization/deserialization.
	UDPInput(const InputProto &serialized);
	virtual InputProto serialize() const;

	virtual std::string get_url() const { return url; }
	virtual void close_socket();

	virtual void add_destination(int stream_index);

	virtual InputStats get_stats() const;

private:
	// Actually gets the packets.
	virtual void do_work();

	// Create the HTTP header.
	void construct_header();

	std::vector<int> stream_indices;

	// The URL and its parsed components.
	std::string url;
	std::string user, host, port, path;

	// The HTTP header we're sending to clients.
	std::string http_header;

	// The socket we are receiving on (or -1).
	int sock;

	// Temporary buffer, sized for the maximum size of an UDP packet.
	char packet_buf[65536];

	// Mutex protecting <stats>.
	mutable std::mutex stats_mutex;

	// The current statistics for this connection. Protected by <stats_mutex>.
	InputStats stats;
};

#endif  // !defined(_UDPINPUT_H)
