#!/usr/bin/env python3
# -*- coding: utf-8 -*-
import os

def findandreplace(text):
    #PyQt5 is bad again :'( but we have a new trick: the header file
    text = text.replace(
        "QtCore.QCoreApplication.translate", "cg_translate")
    
    return text

ui_files = [ x  for x in os.listdir('.') if x.endswith('.ui')]
ui_files.sort()

commands = []
python_files = []
for uif in ui_files:
    python_file = 'ui_' + uif.rsplit('.')[0] +'.py'
    python_files += [python_file]
    commands += ['pyuic5 -o ' + python_file + ' ' + uif]

for command in commands:
    print(command)
    os.system(command)

print("Building ui_qt module: ../cyclograph/qt/ui_qt.py")
outfile = open('../cyclograph/qt/ui_qt.py','w')

with open('imports.py', 'r') as imports:
    outfile.write(imports.read())

for i in range(len(python_files)):
    filename = python_files[i]
    fid = open(filename, 'r')

    for line in fid:
        if line.startswith("from PyQt5 import") or line.startswith("import cyclograph"):
            continue

        res = findandreplace(line)
        outfile.write(res)
    fid.close()

outfile.close()
