/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.gui;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.JNICoordinateConversionService;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.StringHandler;
import geotrans3.utility.Platform;
import geotrans3.utility.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class CreateEllipsoidDlg
extends JDialog {
    private JNIEllipsoidLibrary jniEllipsoidLibrary;
    private JPanel createEllipsoidPanel;
    private JLabel ellipsoidCodeLabel;
    private JLabel ellipsoidNameLabel;
    private JLabel semiMajorAxisLabel;
    private JLabel invFlatteningLabel;
    private JTextField ellipsoidCodeTextField;
    private JTextField ellipsoidNameTextField;
    private JTextField semiMajorAxisTextField;
    private JTextField invFlatteningTextField;
    private JPanel buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;

    public CreateEllipsoidDlg(JNICoordinateConversionService jNICoordinateConversionService, Frame frame, boolean bl) throws CoordinateConversionException {
        super(frame, bl);
        this.jniEllipsoidLibrary = new JNIEllipsoidLibrary(jNICoordinateConversionService.getEllipsoidLibrary());
        this.initComponents();
        this.pack();
        Utility.center(frame, this);
        if (Platform.isJavaV1_3) {
            this.ellipsoidCodeLabel.setForeground(Color.black);
            this.ellipsoidNameLabel.setForeground(Color.black);
            this.semiMajorAxisLabel.setForeground(Color.black);
            this.invFlatteningLabel.setForeground(Color.black);
        }
        if (Platform.isUnix) {
            this.ellipsoidCodeLabel.setFont(new Font("Dialog", 1, 10));
            this.ellipsoidNameLabel.setFont(new Font("Dialog", 1, 10));
            this.semiMajorAxisLabel.setFont(new Font("Dialog", 1, 10));
            this.invFlatteningLabel.setFont(new Font("Dialog", 1, 10));
            this.okButton.setFont(new Font("Dialog", 1, 10));
            this.cancelButton.setFont(new Font("Dialog", 1, 10));
        }
    }

    private void initComponents() {
        this.createEllipsoidPanel = new JPanel();
        this.ellipsoidCodeLabel = new JLabel();
        this.ellipsoidNameLabel = new JLabel();
        this.semiMajorAxisLabel = new JLabel();
        this.invFlatteningLabel = new JLabel();
        this.ellipsoidCodeTextField = new JTextField();
        this.ellipsoidNameTextField = new JTextField();
        this.semiMajorAxisTextField = new JTextField();
        this.invFlatteningTextField = new JTextField();
        this.buttonsPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create Ellipsoid ");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CreateEllipsoidDlg.this.closeDialog(windowEvent);
            }
        });
        this.createEllipsoidPanel.setLayout(new GridBagLayout());
        this.createEllipsoidPanel.setMinimumSize(new Dimension(282, 114));
        this.createEllipsoidPanel.setPreferredSize(new Dimension(282, 114));
        this.ellipsoidCodeLabel.setText("Code:");
        this.ellipsoidCodeLabel.setMaximumSize(new Dimension(120, 16));
        this.ellipsoidCodeLabel.setMinimumSize(new Dimension(120, 16));
        this.ellipsoidCodeLabel.setPreferredSize(new Dimension(120, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.createEllipsoidPanel.add((Component)this.ellipsoidCodeLabel, gridBagConstraints);
        this.ellipsoidNameLabel.setText("Name:");
        this.ellipsoidNameLabel.setMaximumSize(new Dimension(120, 16));
        this.ellipsoidNameLabel.setMinimumSize(new Dimension(120, 16));
        this.ellipsoidNameLabel.setPreferredSize(new Dimension(120, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.createEllipsoidPanel.add((Component)this.ellipsoidNameLabel, gridBagConstraints);
        this.semiMajorAxisLabel.setText("Semi-Major Axis (m):");
        this.semiMajorAxisLabel.setMaximumSize(new Dimension(120, 16));
        this.semiMajorAxisLabel.setMinimumSize(new Dimension(120, 16));
        this.semiMajorAxisLabel.setPreferredSize(new Dimension(120, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.createEllipsoidPanel.add((Component)this.semiMajorAxisLabel, gridBagConstraints);
        this.invFlatteningLabel.setText("Inverse Flattening:");
        this.invFlatteningLabel.setMaximumSize(new Dimension(120, 16));
        this.invFlatteningLabel.setMinimumSize(new Dimension(120, 16));
        this.invFlatteningLabel.setPreferredSize(new Dimension(120, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.createEllipsoidPanel.add((Component)this.invFlatteningLabel, gridBagConstraints);
        this.ellipsoidCodeTextField.setText("WE");
        this.ellipsoidCodeTextField.setBorder(new BevelBorder(1));
        this.ellipsoidCodeTextField.setMinimumSize(new Dimension(120, 20));
        this.ellipsoidCodeTextField.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.createEllipsoidPanel.add((Component)this.ellipsoidCodeTextField, gridBagConstraints);
        this.ellipsoidNameTextField.setText("WGS84");
        this.ellipsoidNameTextField.setBorder(new BevelBorder(1));
        this.ellipsoidNameTextField.setMinimumSize(new Dimension(120, 20));
        this.ellipsoidNameTextField.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.createEllipsoidPanel.add((Component)this.ellipsoidNameTextField, gridBagConstraints);
        this.semiMajorAxisTextField.setText("6378137");
        this.semiMajorAxisTextField.setBorder(new BevelBorder(1));
        this.semiMajorAxisTextField.setMinimumSize(new Dimension(120, 20));
        this.semiMajorAxisTextField.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.createEllipsoidPanel.add((Component)this.semiMajorAxisTextField, gridBagConstraints);
        this.invFlatteningTextField.setText("300");
        this.invFlatteningTextField.setBorder(new BevelBorder(1));
        this.invFlatteningTextField.setMinimumSize(new Dimension(120, 20));
        this.invFlatteningTextField.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.createEllipsoidPanel.add((Component)this.invFlatteningTextField, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.getContentPane().add((Component)this.createEllipsoidPanel, gridBagConstraints2);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.okButton.setMnemonic(79);
        this.okButton.setText("OK");
        this.okButton.setBorder(new BevelBorder(0));
        this.okButton.setMaximumSize(new Dimension(43, 22));
        this.okButton.setMinimumSize(new Dimension(43, 22));
        this.okButton.setPreferredSize(new Dimension(43, 22));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateEllipsoidDlg.this.okActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        this.buttonsPanel.add((Component)this.okButton, gridBagConstraints3);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMaximumSize(new Dimension(43, 22));
        this.cancelButton.setMinimumSize(new Dimension(43, 22));
        this.cancelButton.setPreferredSize(new Dimension(43, 22));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateEllipsoidDlg.this.cancelActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.ipadx = 25;
        gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 0, 8, 0);
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints2);
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void okActionPerformed(ActionEvent actionEvent) {
        StringHandler stringHandler = new StringHandler();
        double d = stringHandler.stringToDouble(this.semiMajorAxisTextField.getText().trim(), "Invalid Semi-Major Axis");
        double d2 = 1.0 / stringHandler.stringToDouble(this.invFlatteningTextField.getText().trim(), "Invalid Inverse Flattening");
        if (stringHandler.getError()) {
            stringHandler.displayErrorMsg(this);
        } else {
            try {
                this.jniEllipsoidLibrary.defineEllipsoid(this.ellipsoidCodeTextField.getText().trim(), this.ellipsoidNameTextField.getText().trim(), d, d2);
                this.setVisible(false);
                this.dispose();
            }
            catch (CoordinateConversionException coordinateConversionException) {
                stringHandler.displayErrorMsg(this, coordinateConversionException.getMessage());
            }
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
    }
}

