//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscheduler

import "time"

type BasicAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType `json:"type,omitempty"`

	// Gets or sets the password, return value will always be empty.
	Password *string `json:"password,omitempty"`

	// Gets or sets the username.
	Username *string `json:"username,omitempty"`
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type BasicAuthentication.
func (b *BasicAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: b.Type,
	}
}

type ClientCertAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType `json:"type,omitempty"`

	// Gets or sets the certificate expiration date.
	CertificateExpirationDate *time.Time `json:"certificateExpirationDate,omitempty"`

	// Gets or sets the certificate subject name.
	CertificateSubjectName *string `json:"certificateSubjectName,omitempty"`

	// Gets or sets the certificate thumbprint.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty"`

	// Gets or sets the certificate password, return value will always be empty.
	Password *string `json:"password,omitempty"`

	// Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
	Pfx *string `json:"pfx,omitempty"`
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type ClientCertAuthentication.
func (c *ClientCertAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: c.Type,
	}
}

// HTTPAuthenticationClassification provides polymorphic access to related types.
// Call the interface's GetHTTPAuthentication() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BasicAuthentication, *ClientCertAuthentication, *HTTPAuthentication, *OAuthAuthentication
type HTTPAuthenticationClassification interface {
	// GetHTTPAuthentication returns the HTTPAuthentication content of the underlying type.
	GetHTTPAuthentication() *HTTPAuthentication
}

type HTTPAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType `json:"type,omitempty"`
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type HTTPAuthentication.
func (h *HTTPAuthentication) GetHTTPAuthentication() *HTTPAuthentication { return h }

type HTTPRequest struct {
	// Gets or sets the authentication method of the request.
	Authentication HTTPAuthenticationClassification `json:"authentication,omitempty"`

	// Gets or sets the request body.
	Body *string `json:"body,omitempty"`

	// Gets or sets the headers.
	Headers map[string]*string `json:"headers,omitempty"`

	// Gets or sets the method of the request.
	Method *string `json:"method,omitempty"`

	// Gets or sets the URI of the request.
	URI *string `json:"uri,omitempty"`
}

type JobAction struct {
	// Gets or sets the error action.
	ErrorAction *JobErrorAction `json:"errorAction,omitempty"`

	// Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage `json:"queueMessage,omitempty"`

	// Gets or sets the http requests.
	Request *HTTPRequest `json:"request,omitempty"`

	// Gets or sets the retry policy.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`

	// Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage `json:"serviceBusQueueMessage,omitempty"`

	// Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage `json:"serviceBusTopicMessage,omitempty"`

	// Gets or sets the job action type.
	Type *JobActionType `json:"type,omitempty"`
}

type JobCollectionDefinition struct {
	// Gets or sets the storage account location.
	Location *string `json:"location,omitempty"`

	// Gets or sets the job collection resource name.
	Name *string `json:"name,omitempty"`

	// Gets or sets the job collection properties.
	Properties *JobCollectionProperties `json:"properties,omitempty"`

	// Gets or sets the tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Gets the job collection resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job collection resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type JobCollectionListResult struct {
	// Gets or sets the URL to get the next set of job collections.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; Gets the job collections.
	Value []*JobCollectionDefinition `json:"value,omitempty" azure:"ro"`
}

type JobCollectionProperties struct {
	// Gets or sets the job collection quota.
	Quota *JobCollectionQuota `json:"quota,omitempty"`

	// Gets or sets the SKU.
	SKU *SKU `json:"sku,omitempty"`

	// Gets or sets the state.
	State *JobCollectionState `json:"state,omitempty"`
}

type JobCollectionQuota struct {
	// Gets or set the maximum job count.
	MaxJobCount *int32 `json:"maxJobCount,omitempty"`

	// Gets or sets the maximum job occurrence.
	MaxJobOccurrence *int32 `json:"maxJobOccurrence,omitempty"`

	// Gets or set the maximum recurrence.
	MaxRecurrence *JobMaxRecurrence `json:"maxRecurrence,omitempty"`
}

// JobCollectionsClientBeginDeleteOptions contains the optional parameters for the JobCollectionsClient.BeginDelete method.
type JobCollectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobCollectionsClientBeginDisableOptions contains the optional parameters for the JobCollectionsClient.BeginDisable method.
type JobCollectionsClientBeginDisableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobCollectionsClientBeginEnableOptions contains the optional parameters for the JobCollectionsClient.BeginEnable method.
type JobCollectionsClientBeginEnableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// JobCollectionsClientCreateOrUpdateOptions contains the optional parameters for the JobCollectionsClient.CreateOrUpdate
// method.
type JobCollectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobCollectionsClientGetOptions contains the optional parameters for the JobCollectionsClient.Get method.
type JobCollectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobCollectionsClientListByResourceGroupOptions contains the optional parameters for the JobCollectionsClient.ListByResourceGroup
// method.
type JobCollectionsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// JobCollectionsClientListBySubscriptionOptions contains the optional parameters for the JobCollectionsClient.ListBySubscription
// method.
type JobCollectionsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// JobCollectionsClientPatchOptions contains the optional parameters for the JobCollectionsClient.Patch method.
type JobCollectionsClientPatchOptions struct {
	// placeholder for future optional parameters
}

type JobDefinition struct {
	// Gets or sets the job properties.
	Properties *JobProperties `json:"properties,omitempty"`

	// READ-ONLY; Gets the job resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type JobErrorAction struct {
	// Gets or sets the storage queue message.
	QueueMessage *StorageQueueMessage `json:"queueMessage,omitempty"`

	// Gets or sets the http requests.
	Request *HTTPRequest `json:"request,omitempty"`

	// Gets or sets the retry policy.
	RetryPolicy *RetryPolicy `json:"retryPolicy,omitempty"`

	// Gets or sets the service bus queue message.
	ServiceBusQueueMessage *ServiceBusQueueMessage `json:"serviceBusQueueMessage,omitempty"`

	// Gets or sets the service bus topic message.
	ServiceBusTopicMessage *ServiceBusTopicMessage `json:"serviceBusTopicMessage,omitempty"`

	// Gets or sets the job error action type.
	Type *JobActionType `json:"type,omitempty"`
}

type JobHistoryDefinition struct {
	// READ-ONLY; Gets the job history identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job history name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the job history properties.
	Properties *JobHistoryDefinitionProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job history resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type JobHistoryDefinitionProperties struct {
	// READ-ONLY; Gets the job history action name.
	ActionName *JobHistoryActionName `json:"actionName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time for this job.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the expected execution time for this job.
	ExpectedExecutionTime *time.Time `json:"expectedExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the message for the job history.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Gets the repeat count for the job.
	RepeatCount *int32 `json:"repeatCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the retry count for job.
	RetryCount *int32 `json:"retryCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time for this job.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the job history status.
	Status *JobExecutionStatus `json:"status,omitempty" azure:"ro"`
}

type JobHistoryFilter struct {
	// Gets or sets the job execution status.
	Status *JobExecutionStatus `json:"status,omitempty"`
}

type JobHistoryListResult struct {
	// Gets or sets the URL to get the next set of job histories.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets the job histories under job.
	Value []*JobHistoryDefinition `json:"value,omitempty"`
}

type JobListResult struct {
	// Gets or sets the URL to get the next set of jobs.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets all jobs under job collection.
	Value []*JobDefinition `json:"value,omitempty"`
}

type JobMaxRecurrence struct {
	// Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// Gets or sets the interval between retries.
	Interval *int32 `json:"interval,omitempty"`
}

type JobProperties struct {
	// Gets or sets the job action.
	Action *JobAction `json:"action,omitempty"`

	// Gets or sets the job recurrence.
	Recurrence *JobRecurrence `json:"recurrence,omitempty"`

	// Gets or sets the job start time.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Gets or set the job state.
	State *JobState `json:"state,omitempty"`

	// READ-ONLY; Gets the job status.
	Status *JobStatus `json:"status,omitempty" azure:"ro"`
}

type JobRecurrence struct {
	// Gets or sets the maximum number of times that the job should run.
	Count *int32 `json:"count,omitempty"`

	// Gets or sets the time at which the job will complete.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// Gets or sets the interval between retries.
	Interval *int32                 `json:"interval,omitempty"`
	Schedule *JobRecurrenceSchedule `json:"schedule,omitempty"`
}

type JobRecurrenceSchedule struct {
	// Gets or sets the hours of the day that the job should execute at.
	Hours []*int32 `json:"hours,omitempty"`

	// Gets or sets the minutes of the hour that the job should execute at.
	Minutes []*int32 `json:"minutes,omitempty"`

	// Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
	MonthDays []*int32 `json:"monthDays,omitempty"`

	// Gets or sets the occurrences of days within a month.
	MonthlyOccurrences []*JobRecurrenceScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`

	// Gets or sets the days of the week that the job should execute on.
	WeekDays []*DayOfWeek `json:"weekDays,omitempty"`
}

type JobRecurrenceScheduleMonthlyOccurrence struct {
	// Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday, sunday.
	Day *JobScheduleDay `json:"day,omitempty"`

	// Gets or sets the occurrence. Must be between -5 and 5.
	Occurrence *int32 `json:"Occurrence,omitempty"`
}

type JobStateFilter struct {
	// Gets or sets the job state.
	State *JobState `json:"state,omitempty"`
}

type JobStatus struct {
	// READ-ONLY; Gets the number of times this job has executed.
	ExecutionCount *int32 `json:"executionCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the number of times this job has failed.
	FailureCount *int32 `json:"failureCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the number of faulted occurrences (occurrences that were retried and failed as many times as the retry
	// policy states).
	FaultedCount *int32 `json:"faultedCount,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time the last occurrence executed in ISO-8601 format. Could be empty if job has not run yet.
	LastExecutionTime *time.Time `json:"lastExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time of the next occurrence in ISO-8601 format. Could be empty if the job is completed.
	NextExecutionTime *time.Time `json:"nextExecutionTime,omitempty" azure:"ro"`
}

// JobsClientCreateOrUpdateOptions contains the optional parameters for the JobsClient.CreateOrUpdate method.
type JobsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// JobsClientDeleteOptions contains the optional parameters for the JobsClient.Delete method.
type JobsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// JobsClientGetOptions contains the optional parameters for the JobsClient.Get method.
type JobsClientGetOptions struct {
	// placeholder for future optional parameters
}

// JobsClientListJobHistoryOptions contains the optional parameters for the JobsClient.ListJobHistory method.
type JobsClientListJobHistoryOptions struct {
	// The filter to apply on the job state.
	Filter *string
	// The (0-based) index of the job history list from which to begin requesting entries.
	Skip *int32
	// the number of job history to request, in the of range of [1..100].
	Top *int32
}

// JobsClientListOptions contains the optional parameters for the JobsClient.List method.
type JobsClientListOptions struct {
	// The filter to apply on the job state.
	Filter *string
	// The (0-based) index of the job history list from which to begin requesting entries.
	Skip *int32
	// The number of jobs to request, in the of range of [1..100].
	Top *int32
}

// JobsClientPatchOptions contains the optional parameters for the JobsClient.Patch method.
type JobsClientPatchOptions struct {
	// placeholder for future optional parameters
}

// JobsClientRunOptions contains the optional parameters for the JobsClient.Run method.
type JobsClientRunOptions struct {
	// placeholder for future optional parameters
}

type OAuthAuthentication struct {
	// REQUIRED; Gets or sets the HTTP authentication type.
	Type *HTTPAuthenticationType `json:"type,omitempty"`

	// Gets or sets the audience.
	Audience *string `json:"audience,omitempty"`

	// Gets or sets the client identifier.
	ClientID *string `json:"clientId,omitempty"`

	// Gets or sets the secret, return value will always be empty.
	Secret *string `json:"secret,omitempty"`

	// Gets or sets the tenant.
	Tenant *string `json:"tenant,omitempty"`
}

// GetHTTPAuthentication implements the HTTPAuthenticationClassification interface for type OAuthAuthentication.
func (o *OAuthAuthentication) GetHTTPAuthentication() *HTTPAuthentication {
	return &HTTPAuthentication{
		Type: o.Type,
	}
}

type RetryPolicy struct {
	// Gets or sets the number of times a retry should be attempted.
	RetryCount *int32 `json:"retryCount,omitempty"`

	// Gets or sets the retry interval between retries, specify duration in ISO 8601 format.
	RetryInterval *string `json:"retryInterval,omitempty"`

	// Gets or sets the retry strategy to be used.
	RetryType *RetryType `json:"retryType,omitempty"`
}

type SKU struct {
	// Gets or set the SKU.
	Name *SKUDefinition `json:"name,omitempty"`
}

type ServiceBusAuthentication struct {
	// Gets or sets the SAS key.
	SasKey *string `json:"sasKey,omitempty"`

	// Gets or sets the SAS key name.
	SasKeyName *string `json:"sasKeyName,omitempty"`

	// Gets or sets the authentication type.
	Type *ServiceBusAuthenticationType `json:"type,omitempty"`
}

type ServiceBusBrokeredMessageProperties struct {
	// Gets or sets the content type.
	ContentType *string `json:"contentType,omitempty"`

	// Gets or sets the correlation ID.
	CorrelationID *string `json:"correlationId,omitempty"`

	// Gets or sets the force persistence.
	ForcePersistence *bool `json:"forcePersistence,omitempty"`

	// Gets or sets the label.
	Label *string `json:"label,omitempty"`

	// Gets or sets the message ID.
	MessageID *string `json:"messageId,omitempty"`

	// Gets or sets the partition key.
	PartitionKey *string `json:"partitionKey,omitempty"`

	// Gets or sets the reply to.
	ReplyTo *string `json:"replyTo,omitempty"`

	// Gets or sets the reply to session ID.
	ReplyToSessionID *string `json:"replyToSessionId,omitempty"`

	// Gets or sets the scheduled enqueue time UTC.
	ScheduledEnqueueTimeUTC *time.Time `json:"scheduledEnqueueTimeUtc,omitempty"`

	// Gets or sets the session ID.
	SessionID *string `json:"sessionId,omitempty"`

	// Gets or sets the time to live.
	TimeToLive *string `json:"timeToLive,omitempty"`

	// Gets or sets the to.
	To *string `json:"to,omitempty"`

	// Gets or sets the via partition key.
	ViaPartitionKey *string `json:"viaPartitionKey,omitempty"`
}

type ServiceBusMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties,omitempty"`

	// Gets or sets the message.
	Message *string `json:"message,omitempty"`

	// Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType `json:"transportType,omitempty"`
}

type ServiceBusQueueMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties,omitempty"`

	// Gets or sets the message.
	Message *string `json:"message,omitempty"`

	// Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`

	// Gets or sets the queue name.
	QueueName *string `json:"queueName,omitempty"`

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType `json:"transportType,omitempty"`
}

type ServiceBusTopicMessage struct {
	// Gets or sets the Service Bus authentication.
	Authentication *ServiceBusAuthentication `json:"authentication,omitempty"`

	// Gets or sets the brokered message properties.
	BrokeredMessageProperties *ServiceBusBrokeredMessageProperties `json:"brokeredMessageProperties,omitempty"`

	// Gets or sets the custom message properties.
	CustomMessageProperties map[string]*string `json:"customMessageProperties,omitempty"`

	// Gets or sets the message.
	Message *string `json:"message,omitempty"`

	// Gets or sets the namespace.
	Namespace *string `json:"namespace,omitempty"`

	// Gets or sets the topic path.
	TopicPath *string `json:"topicPath,omitempty"`

	// Gets or sets the transport type.
	TransportType *ServiceBusTransportType `json:"transportType,omitempty"`
}

type StorageQueueMessage struct {
	// Gets or sets the message.
	Message *string `json:"message,omitempty"`

	// Gets or sets the queue name.
	QueueName *string `json:"queueName,omitempty"`

	// Gets or sets the SAS key.
	SasToken *string `json:"sasToken,omitempty"`

	// Gets or sets the storage account name.
	StorageAccount *string `json:"storageAccount,omitempty"`
}
