//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armwindowsiot

import "time"

// DeviceService - The description of the Windows IoT Device Service.
type DeviceService struct {
	// The Etag field is not required. If it is provided in the response body, it must also be provided as a header per the normal
	// ETag convention.
	Etag *string `json:"etag,omitempty"`

	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// The properties of a Windows IoT Device Service.
	Properties *DeviceServiceProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeviceServiceCheckNameAvailabilityParameters - Input values.
type DeviceServiceCheckNameAvailabilityParameters struct {
	// REQUIRED; The name of the Windows IoT Device Service to check.
	Name *string `json:"name,omitempty"`
}

// DeviceServiceDescriptionListResult - The JSON-serialized array of DeviceService objects with a next link.
type DeviceServiceDescriptionListResult struct {
	// The array of DeviceService objects.
	Value []*DeviceService `json:"value,omitempty"`

	// READ-ONLY; The next link.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeviceServiceNameAvailabilityInfo - The properties indicating whether a given Windows IoT Device Service name is available.
type DeviceServiceNameAvailabilityInfo struct {
	// The detailed reason message.
	Message *string `json:"message,omitempty"`

	// READ-ONLY; The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason for unavailability.
	Reason *ServiceNameUnavailabilityReason `json:"reason,omitempty" azure:"ro"`
}

// DeviceServiceProperties - The properties of a Windows IoT Device Service.
type DeviceServiceProperties struct {
	// Windows IoT Device Service OEM AAD domain
	AdminDomainName *string `json:"adminDomainName,omitempty"`

	// Windows IoT Device Service ODM AAD domain
	BillingDomainName *string `json:"billingDomainName,omitempty"`

	// Windows IoT Device Service notes.
	Notes *string `json:"notes,omitempty"`

	// Windows IoT Device Service device allocation,
	Quantity *int64 `json:"quantity,omitempty"`

	// READ-ONLY; Windows IoT Device Service start date,
	StartDate *time.Time `json:"startDate,omitempty" azure:"ro"`
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// The error object.
	Error *ErrorDetailsError `json:"error,omitempty"`
}

// ErrorDetailsError - The error object.
type ErrorDetailsError struct {
	// One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`

	// A human-readable representation of the error's details.
	Details *string `json:"details,omitempty"`

	// A human-readable representation of the error.
	Message *string `json:"message,omitempty"`

	// The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// OperationDisplayInfo - The operation supported by Azure Data Catalog Service.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Azure Data Catalog Service.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operation supported by Azure Data Catalog Service.
type OperationEntity struct {
	// The operation supported by Azure Data Catalog Service.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// Indicates the executor of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationListResult - Result of the request to list Windows IoT Device Service operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Windows IoT Device Service operations supported by the Microsoft.WindowsIoT resource provider.
	Value []*OperationEntity `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required location
// and tags
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicesClientCheckDeviceServiceNameAvailabilityOptions contains the optional parameters for the ServicesClient.CheckDeviceServiceNameAvailability
// method.
type ServicesClientCheckDeviceServiceNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientCreateOrUpdateOptions contains the optional parameters for the ServicesClient.CreateOrUpdate method.
type ServicesClientCreateOrUpdateOptions struct {
	// ETag of the Windows IoT Device Service. Do not specify for creating a new Windows IoT Device Service. Required to update
	// an existing Windows IoT Device Service.
	IfMatch *string
}

// ServicesClientDeleteOptions contains the optional parameters for the ServicesClient.Delete method.
type ServicesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientGetOptions contains the optional parameters for the ServicesClient.Get method.
type ServicesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListByResourceGroupOptions contains the optional parameters for the ServicesClient.ListByResourceGroup method.
type ServicesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientListOptions contains the optional parameters for the ServicesClient.List method.
type ServicesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServicesClientUpdateOptions contains the optional parameters for the ServicesClient.Update method.
type ServicesClientUpdateOptions struct {
	// ETag of the Windows IoT Device Service. Do not specify for creating a brand new Windows IoT Device Service. Required to
	// update an existing Windows IoT Device Service.
	IfMatch *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}
