// Code generated by smithy-go-codegen DO NOT EDIT.

package mailmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mailmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all ingress endpoint resources.
func (c *Client) ListIngressPoints(ctx context.Context, params *ListIngressPointsInput, optFns ...func(*Options)) (*ListIngressPointsOutput, error) {
	if params == nil {
		params = &ListIngressPointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIngressPoints", params, optFns, c.addOperationListIngressPointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIngressPointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIngressPointsInput struct {

	// If you received a pagination token from a previous call to this API, you can
	// provide it here to continue paginating through the next page of results.
	NextToken *string

	// The maximum number of ingress endpoint resources that are returned per call.
	// You can use NextToken to obtain further ingress endpoints.
	PageSize *int32

	noSmithyDocumentSerde
}

type ListIngressPointsOutput struct {

	// The list of ingress endpoints.
	IngressPoints []types.IngressPoint

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIngressPointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListIngressPoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListIngressPoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIngressPoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIngressPoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListIngressPointsAPIClient is a client that implements the ListIngressPoints
// operation.
type ListIngressPointsAPIClient interface {
	ListIngressPoints(context.Context, *ListIngressPointsInput, ...func(*Options)) (*ListIngressPointsOutput, error)
}

var _ ListIngressPointsAPIClient = (*Client)(nil)

// ListIngressPointsPaginatorOptions is the paginator options for ListIngressPoints
type ListIngressPointsPaginatorOptions struct {
	// The maximum number of ingress endpoint resources that are returned per call.
	// You can use NextToken to obtain further ingress endpoints.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListIngressPointsPaginator is a paginator for ListIngressPoints
type ListIngressPointsPaginator struct {
	options   ListIngressPointsPaginatorOptions
	client    ListIngressPointsAPIClient
	params    *ListIngressPointsInput
	nextToken *string
	firstPage bool
}

// NewListIngressPointsPaginator returns a new ListIngressPointsPaginator
func NewListIngressPointsPaginator(client ListIngressPointsAPIClient, params *ListIngressPointsInput, optFns ...func(*ListIngressPointsPaginatorOptions)) *ListIngressPointsPaginator {
	if params == nil {
		params = &ListIngressPointsInput{}
	}

	options := ListIngressPointsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListIngressPointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListIngressPointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListIngressPoints page.
func (p *ListIngressPointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListIngressPointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	result, err := p.client.ListIngressPoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListIngressPoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIngressPoints",
	}
}
