// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/neptunedata/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains custom model training parameters. See [Custom models in Neptune ML].
//
// [Custom models in Neptune ML]: https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-custom-models.html
type CustomModelTrainingParameters struct {

	// The path to the Amazon S3 location where the Python module implementing your
	// model is located. This must point to a valid existing Amazon S3 location that
	// contains, at a minimum, a training script, a transform script, and a
	// model-hpo-configuration.json file.
	//
	// This member is required.
	SourceS3DirectoryPath *string

	// The name of the entry point in your module of a script that performs model
	// training and takes hyperparameters as command-line arguments, including fixed
	// hyperparameters. The default is training.py .
	TrainingEntryPointScript *string

	// The name of the entry point in your module of a script that should be run after
	// the best model from the hyperparameter search has been identified, to compute
	// the model artifacts necessary for model deployment. It should be able to run
	// with no command-line arguments.The default is transform.py .
	TransformEntryPointScript *string

	noSmithyDocumentSerde
}

// Contains custom model transform parameters. See [Use a trained model to generate new model artifacts].
//
// [Use a trained model to generate new model artifacts]: https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html
type CustomModelTransformParameters struct {

	// The path to the Amazon S3 location where the Python module implementing your
	// model is located. This must point to a valid existing Amazon S3 location that
	// contains, at a minimum, a training script, a transform script, and a
	// model-hpo-configuration.json file.
	//
	// This member is required.
	SourceS3DirectoryPath *string

	// The name of the entry point in your module of a script that should be run after
	// the best model from the hyperparameter search has been identified, to compute
	// the model artifacts necessary for model deployment. It should be able to run
	// with no command-line arguments. The default is transform.py .
	TransformEntryPointScript *string

	noSmithyDocumentSerde
}

// The payload for DeleteStatistics.
type DeleteStatisticsValueMap struct {

	// The current status of the statistics.
	Active *bool

	// The ID of the statistics generation run that is currently occurring.
	StatisticsId *string

	noSmithyDocumentSerde
}

// An edge structure.
type EdgeStructure struct {

	// The number of edges that have this specific structure.
	Count *int64

	// A list of edge properties present in this specific structure.
	EdgeProperties []string

	noSmithyDocumentSerde
}

// A structure containing the fast reset token used to initiate a fast reset.
type FastResetToken struct {

	// A UUID generated by the database in the initiateDatabaseReset action, and then
	// consumed by the performDatabaseReset to reset the database.
	Token *string

	noSmithyDocumentSerde
}

// Captures the status of a Gremlin query (see the [Gremlin query status API] page).
//
// [Gremlin query status API]: https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html
type GremlinQueryStatus struct {

	// The query statistics of the Gremlin query.
	QueryEvalStats *QueryEvalStats

	// The ID of the Gremlin query.
	QueryId *string

	// The query string of the Gremlin query.
	QueryString *string

	noSmithyDocumentSerde
}

// Contains status components of a Gremlin query.
type GremlinQueryStatusAttributes struct {

	// Attributes of the Gremlin query status.
	Attributes document.Interface

	// The HTTP response code returned fro the Gremlin query request..
	Code *int32

	// The status message.
	Message *string

	noSmithyDocumentSerde
}

// Contains a list of load IDs.
type LoaderIdResult struct {

	// A list of load IDs.
	LoadIds []string

	noSmithyDocumentSerde
}

// Contains a Neptune ML configuration.
type MlConfigDefinition struct {

	// The ARN for the configuration.
	Arn *string

	// The configuration name.
	Name *string

	noSmithyDocumentSerde
}

// Defines a Neptune ML resource.
type MlResourceDefinition struct {

	// The resource ARN.
	Arn *string

	// The CloudWatch log URL for the resource.
	CloudwatchLogUrl *string

	// The failure reason, in case of a failure.
	FailureReason *string

	// The resource name.
	Name *string

	// The output location.
	OutputLocation *string

	// The resource status.
	Status *string

	noSmithyDocumentSerde
}

// A node structure.
type NodeStructure struct {

	// Number of nodes that have this specific structure.
	Count *int64

	// A list of distinct outgoing edge labels present in this specific structure.
	DistinctOutgoingEdgeLabels []string

	// A list of the node properties present in this specific structure.
	NodeProperties []string

	noSmithyDocumentSerde
}

// A Gremlin or openCypher change record.
type PropertygraphData struct {

	// The ID of the Gremlin or openCypher element.
	//
	// This member is required.
	Id *string

	// The property name. For element labels, this is label .
	//
	// This member is required.
	Key *string

	// The type of this Gremlin or openCypher element. Must be one of:
	//
	//   - v1 - Vertex label for Gremlin, or node label for openCypher.
	//
	//   - vp - Vertex properties for Gremlin, or node properties for openCypher.
	//
	//   - e - Edge and edge label for Gremlin, or relationship and relationship type
	//   for openCypher.
	//
	//   - ep - Edge properties for Gremlin, or relationship properties for openCypher.
	//
	// This member is required.
	Type *string

	// This is a JSON object that contains a value field for the value itself, and a
	// datatype field for the JSON data type of that value:
	//
	// This member is required.
	Value document.Interface

	// If this is an edge (type = e ), the ID of the corresponding from vertex or
	// source node.
	From *string

	// If this is an edge (type = e ), the ID of the corresponding to vertex or target
	// node.
	To *string

	noSmithyDocumentSerde
}

// Structure of a property graph record.
type PropertygraphRecord struct {

	// The time at which the commit for the transaction was requested, in milliseconds
	// from the Unix epoch.
	//
	// This member is required.
	CommitTimestampInMillis *int64

	// The serialized Gremlin or openCypher change record.
	//
	// This member is required.
	Data *PropertygraphData

	// The sequence identifier of the stream change record.
	//
	// This member is required.
	EventId map[string]string

	// The operation that created the change.
	//
	// This member is required.
	Op *string

	// Only present if this operation is the last one in its transaction. If present,
	// it is set to true. It is useful for ensuring that an entire transaction is
	// consumed.
	IsLastOp *bool

	noSmithyDocumentSerde
}

// The graph summary API returns a read-only list of node and edge labels and
// property keys, along with counts of nodes, edges, and properties. See [Graph summary response for a property graph (PG)].
//
// [Graph summary response for a property graph (PG)]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-graph-summary.html#neptune-graph-summary-pg-response
type PropertygraphSummary struct {

	// A list of the distinct edge labels in the graph.
	EdgeLabels []string

	// A list of the distinct edge properties in the graph, along with the count of
	// edges where each property is used.
	EdgeProperties []map[string]int64

	// This field is only present when the requested mode is DETAILED . It contains a
	// list of edge structures.
	EdgeStructures []EdgeStructure

	// A list of the distinct node labels in the graph.
	NodeLabels []string

	// The number of distinct node properties in the graph.
	NodeProperties []map[string]int64

	// This field is only present when the requested mode is DETAILED . It contains a
	// list of node structures.
	NodeStructures []NodeStructure

	// The number of distinct edge labels in the graph.
	NumEdgeLabels *int64

	// The number of distinct edge properties in the graph.
	NumEdgeProperties *int64

	// The number of edges in the graph.
	NumEdges *int64

	// The number of distinct node labels in the graph.
	NumNodeLabels *int64

	// A list of the distinct node properties in the graph, along with the count of
	// nodes where each property is used.
	NumNodeProperties *int64

	// The number of nodes in the graph.
	NumNodes *int64

	// The total number of usages of all edge properties.
	TotalEdgePropertyValues *int64

	// The total number of usages of all node properties.
	TotalNodePropertyValues *int64

	noSmithyDocumentSerde
}

// Payload for the property graph summary response.
type PropertygraphSummaryValueMap struct {

	// The graph summary.
	GraphSummary *PropertygraphSummary

	// The timestamp, in ISO 8601 format, of the time at which Neptune last computed
	// statistics.
	LastStatisticsComputationTime *time.Time

	// The version of this graph summary response.
	Version *string

	noSmithyDocumentSerde
}

// Structure to capture query statistics such as how many queries are running,
// accepted or waiting and their details.
type QueryEvalStats struct {

	// Set to TRUE if the query was cancelled, or FALSE otherwise.
	Cancelled *bool

	// The number of milliseconds the query has been running so far.
	Elapsed *int32

	// The number of subqueries in this query.
	Subqueries document.Interface

	// Indicates how long the query waited, in milliseconds.
	Waited *int32

	noSmithyDocumentSerde
}

// Structure for expressing the query language version.
type QueryLanguageVersion struct {

	// The version of the query language.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The RDF graph summary API returns a read-only list of classes and predicate
// keys, along with counts of quads, subjects, and predicates.
type RDFGraphSummary struct {

	// A list of the classes in the graph.
	Classes []string

	// The number of classes in the graph.
	NumClasses *int64

	// The number of distinct predicates in the graph.
	NumDistinctPredicates *int64

	// The number of distinct subjects in the graph.
	NumDistinctSubjects *int64

	// The number of quads in the graph.
	NumQuads *int64

	// "A list of predicates in the graph, along with the predicate counts.
	Predicates []map[string]int64

	// This field is only present when the request mode is DETAILED . It contains a
	// list of subject structures.
	SubjectStructures []SubjectStructure

	noSmithyDocumentSerde
}

// Payload for an RDF graph summary response.
type RDFGraphSummaryValueMap struct {

	// The graph summary of an RDF graph. See [Graph summary response for an RDF graph].
	//
	// [Graph summary response for an RDF graph]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-graph-summary.html#neptune-graph-summary-rdf-response
	GraphSummary *RDFGraphSummary

	// The timestamp, in ISO 8601 format, of the time at which Neptune last computed
	// statistics.
	LastStatisticsComputationTime *time.Time

	// The version of this graph summary response.
	Version *string

	noSmithyDocumentSerde
}

// Statistics for REFRESH mode.
type RefreshStatisticsIdMap struct {

	// The ID of the statistics generation run that is currently occurring.
	StatisticsId *string

	noSmithyDocumentSerde
}

// Neptune logs are converted to SPARQL quads in the graph using the Resource
// Description Framework (RDF) [N-QUADS]language defined in the W3C RDF 1.1 N-Quads
// specification
//
// [N-QUADS]: https://www.w3.org/TR/n-quads/
type SparqlData struct {

	// Holds an [N-QUADS] statement expressing the changed quad.
	//
	// [N-QUADS]: https://www.w3.org/TR/n-quads/
	//
	// This member is required.
	Stmt *string

	noSmithyDocumentSerde
}

// A serialized SPARQL stream record capturing a change-log entry for the RDF
// graph.
type SparqlRecord struct {

	// The time at which the commit for the transaction was requested, in milliseconds
	// from the Unix epoch.
	//
	// This member is required.
	CommitTimestampInMillis *int64

	// The serialized SPARQL change record. The serialization formats of each record
	// are described in more detail in [Serialization Formats in Neptune Streams].
	//
	// [Serialization Formats in Neptune Streams]: https://docs.aws.amazon.com/neptune/latest/userguide/streams-change-formats.html
	//
	// This member is required.
	Data *SparqlData

	// The sequence identifier of the stream change record.
	//
	// This member is required.
	EventId map[string]string

	// The operation that created the change.
	//
	// This member is required.
	Op *string

	// Only present if this operation is the last one in its transaction. If present,
	// it is set to true. It is useful for ensuring that an entire transaction is
	// consumed.
	IsLastOp *bool

	noSmithyDocumentSerde
}

// Contains statistics information. The DFE engine uses information about the data
// in your Neptune graph to make effective trade-offs when planning query
// execution. This information takes the form of statistics that include so-called
// characteristic sets and predicate statistics that can guide query planning. See [Managing statistics for the Neptune DFE to use]
// .
//
// [Managing statistics for the Neptune DFE to use]: https://docs.aws.amazon.com/neptune/latest/userguide/neptune-dfe-statistics.html
type Statistics struct {

	// Indicates whether or not DFE statistics generation is enabled at all.
	Active *bool

	// Indicates whether or not automatic statistics generation is enabled.
	AutoCompute *bool

	// The UTC time at which DFE statistics have most recently been generated.
	Date *time.Time

	// A note about problems in the case where statistics are invalid.
	Note *string

	// A StatisticsSummary structure that contains:
	//
	//   - signatureCount - The total number of signatures across all characteristic
	//   sets.
	//
	//   - instanceCount - The total number of characteristic-set instances.
	//
	//   - predicateCount - The total number of unique predicates.
	SignatureInfo *StatisticsSummary

	// Reports the ID of the current statistics generation run. A value of -1
	// indicates that no statistics have been generated.
	StatisticsId *string

	noSmithyDocumentSerde
}

// Information about the characteristic sets generated in the statistics.
type StatisticsSummary struct {

	// The total number of characteristic-set instances.
	InstanceCount *int32

	// The total number of unique predicates.
	PredicateCount *int32

	// The total number of signatures across all characteristic sets.
	SignatureCount *int32

	noSmithyDocumentSerde
}

// A subject structure.
type SubjectStructure struct {

	// Number of occurrences of this specific structure.
	Count *int64

	// A list of predicates present in this specific structure.
	Predicates []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
