/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <pmt/pmt.h>
// pydoc.h is automatically generated in the build directory
#include <pmt_pydoc.h>

void bind_pmt(py::module& m)
{
    using pmt_base = pmt::pmt_base;
    // using exception    = pmt::exception;
    // using wrong_type    = pmt::wrong_type;
    // using out_of_range    = pmt::out_of_range;
    // using notimplemented    = pmt::notimplemented;
    using comparator = pmt::comparator;

    py::class_<pmt_base, std::shared_ptr<pmt_base>>(m, "pmt_base")

        .def(py::init<>(), D(pmt_base, pmt_base))
        .def("__str__", [](const pmt::pmt_t& p) { return pmt::write_string(p); })
        .def("__repr__", [](const pmt::pmt_t& p) { return pmt::write_string(p); })
        .def("is_bool", &pmt_base::is_bool, D(pmt_base, is_bool))


        .def("is_symbol", &pmt_base::is_symbol, D(pmt_base, is_symbol))


        .def("is_number", &pmt_base::is_number, D(pmt_base, is_number))


        .def("is_integer", &pmt_base::is_integer, D(pmt_base, is_integer))


        .def("is_uint64", &pmt_base::is_uint64, D(pmt_base, is_uint64))


        .def("is_real", &pmt_base::is_real, D(pmt_base, is_real))


        .def("is_complex", &pmt_base::is_complex, D(pmt_base, is_complex))


        .def("is_null", &pmt_base::is_null, D(pmt_base, is_null))


        .def("is_pair", &pmt_base::is_pair, D(pmt_base, is_pair))


        .def("is_tuple", &pmt_base::is_tuple, D(pmt_base, is_tuple))


        .def("is_vector", &pmt_base::is_vector, D(pmt_base, is_vector))


        .def("is_dict", &pmt_base::is_dict, D(pmt_base, is_dict))


        .def("is_any", &pmt_base::is_any, D(pmt_base, is_any))


        .def("is_uniform_vector",
             &pmt_base::is_uniform_vector,
             D(pmt_base, is_uniform_vector))


        .def("is_u8vector", &pmt_base::is_u8vector, D(pmt_base, is_u8vector))


        .def("is_s8vector", &pmt_base::is_s8vector, D(pmt_base, is_s8vector))


        .def("is_u16vector", &pmt_base::is_u16vector, D(pmt_base, is_u16vector))


        .def("is_s16vector", &pmt_base::is_s16vector, D(pmt_base, is_s16vector))


        .def("is_u32vector", &pmt_base::is_u32vector, D(pmt_base, is_u32vector))


        .def("is_s32vector", &pmt_base::is_s32vector, D(pmt_base, is_s32vector))


        .def("is_u64vector", &pmt_base::is_u64vector, D(pmt_base, is_u64vector))


        .def("is_s64vector", &pmt_base::is_s64vector, D(pmt_base, is_s64vector))


        .def("is_f32vector", &pmt_base::is_f32vector, D(pmt_base, is_f32vector))


        .def("is_f64vector", &pmt_base::is_f64vector, D(pmt_base, is_f64vector))


        .def("is_c32vector", &pmt_base::is_c32vector, D(pmt_base, is_c32vector))


        .def("is_c64vector", &pmt_base::is_c64vector, D(pmt_base, is_c64vector))

        ;


    // py::class_<exception,std::logic_error,
    //     std::shared_ptr<exception>>(m, "exception")

    //     .def(py::init<std::string const &,pmt::pmt_t>(),           py::arg("msg"),
    //        py::arg("obj")
    //     )
    //     .def(py::init<pmt::exception const &>(),           py::arg("arg0")
    //     )

    //     ;


    // py::class_<wrong_type,pmt::exception,
    //     std::shared_ptr<wrong_type>>(m, "wrong_type")

    //     .def(py::init<std::string const &,pmt::pmt_t>(),           py::arg("msg"),
    //        py::arg("obj")
    //     )
    //     .def(py::init<pmt::wrong_type const &>(),           py::arg("arg0")
    //     )

    //     ;


    // py::class_<out_of_range,pmt::exception,
    //     std::shared_ptr<out_of_range>>(m, "out_of_range")

    //     .def(py::init<std::string const &,pmt::pmt_t>(),           py::arg("msg"),
    //        py::arg("obj")
    //     )
    //     .def(py::init<pmt::out_of_range const &>(),           py::arg("arg0")
    //     )

    //     ;


    // py::class_<notimplemented,pmt::exception,
    //     std::shared_ptr<notimplemented>>(m, "notimplemented")

    //     .def(py::init<std::string const &,pmt::pmt_t>(),           py::arg("msg"),
    //        py::arg("obj")
    //     )
    //     .def(py::init<pmt::notimplemented const &>(),           py::arg("arg0")
    //     )

    //     ;


    py::class_<comparator, std::shared_ptr<comparator>>(m, "comparator")

        .def(py::init<>())
        .def(py::init<pmt::comparator const&>(), py::arg("arg0"))

        ;


    m.def("get_PMT_NIL", &::pmt::get_PMT_NIL, D(get_PMT_NIL));


    m.def("get_PMT_T", &::pmt::get_PMT_T, D(get_PMT_T));


    m.def("get_PMT_F", &::pmt::get_PMT_F, D(get_PMT_F));


    m.def("get_PMT_EOF", &::pmt::get_PMT_EOF, D(get_PMT_EOF));


    m.def("is_bool", &::pmt::is_bool, py::arg("obj"), D(is_bool));


    m.def("is_true", &::pmt::is_true, py::arg("obj"), D(is_true));


    m.def("is_false", &::pmt::is_false, py::arg("obj"), D(is_false));


    m.def("from_bool", &::pmt::from_bool, py::arg("val"), D(from_bool));


    m.def("to_bool", &::pmt::to_bool, py::arg("val"), D(to_bool));


    m.def("is_symbol", &::pmt::is_symbol, py::arg("obj"), D(is_symbol));


    m.def(
        "string_to_symbol", &::pmt::string_to_symbol, py::arg("s"), D(string_to_symbol));


    m.def("intern", &::pmt::intern, py::arg("s"), D(intern));


    m.def("symbol_to_string",
          &::pmt::symbol_to_string,
          py::arg("sym"),
          D(symbol_to_string));


    m.def("is_number", &::pmt::is_number, py::arg("obj"), D(is_number));


    m.def("is_integer", &::pmt::is_integer, py::arg("x"), D(is_integer));


    m.def("from_long", &::pmt::from_long, py::arg("x"), D(from_long));


    m.def("to_long", &::pmt::to_long, py::arg("x"), D(to_long));


    m.def("is_uint64", &::pmt::is_uint64, py::arg("x"), D(is_uint64));


    m.def("from_uint64", &::pmt::from_uint64, py::arg("x"), D(from_uint64));


    m.def("to_uint64", &::pmt::to_uint64, py::arg("x"), D(to_uint64));


    m.def("is_real", &::pmt::is_real, py::arg("obj"), D(is_real));


    m.def("from_double", &::pmt::from_double, py::arg("x"), D(from_double));


    m.def("from_float", &::pmt::from_float, py::arg("x"), D(from_float));


    m.def("to_double", &::pmt::to_double, py::arg("x"), D(to_double));


    m.def("to_float", &::pmt::to_float, py::arg("x"), D(to_float));


    m.def("is_complex", &::pmt::is_complex, py::arg("obj"), D(is_complex));


    m.def("make_rectangular",
          &::pmt::make_rectangular,
          py::arg("re"),
          py::arg("im"),
          D(make_rectangular));


    m.def("from_complex",
          (pmt::pmt_t(*)(double, double)) & ::pmt::from_complex,
          py::arg("re"),
          py::arg("im"),
          D(from_complex, 0));


    m.def("from_complex",
          (pmt::pmt_t(*)(std::complex<double> const&)) & ::pmt::from_complex,
          py::arg("z"),
          D(from_complex, 1));


    m.def("pmt_from_complex",
          (pmt::pmt_t(*)(double, double)) & ::pmt::pmt_from_complex,
          py::arg("re"),
          py::arg("im"),
          D(pmt_from_complex, 0));


    m.def("pmt_from_complex",
          (pmt::pmt_t(*)(std::complex<double> const&)) & ::pmt::pmt_from_complex,
          py::arg("z"),
          D(pmt_from_complex, 1));


    m.def("to_complex", &::pmt::to_complex, py::arg("z"), D(to_complex));


    m.def("is_null", &::pmt::is_null, py::arg("x"), D(is_null));


    m.def("is_pair", &::pmt::is_pair, py::arg("obj"), D(is_pair));


    m.def("cons", &::pmt::cons, py::arg("x"), py::arg("y"), D(cons));


    m.def("dcons", &::pmt::dcons, py::arg("x"), py::arg("y"), D(dcons));


    m.def("car", &::pmt::car, py::arg("pair"), D(car));


    m.def("cdr", &::pmt::cdr, py::arg("pair"), D(cdr));


    m.def("set_car", &::pmt::set_car, py::arg("pair"), py::arg("value"), D(set_car));


    m.def("set_cdr", &::pmt::set_cdr, py::arg("pair"), py::arg("value"), D(set_cdr));


    m.def("caar", &::pmt::caar, py::arg("pair"), D(caar));


    m.def("cadr", &::pmt::cadr, py::arg("pair"), D(cadr));


    m.def("cdar", &::pmt::cdar, py::arg("pair"), D(cdar));


    m.def("cddr", &::pmt::cddr, py::arg("pair"), D(cddr));


    m.def("caddr", &::pmt::caddr, py::arg("pair"), D(caddr));


    m.def("cadddr", &::pmt::cadddr, py::arg("pair"), D(cadddr));


    m.def("is_tuple", &::pmt::is_tuple, py::arg("x"), D(is_tuple));


    m.def("make_tuple", (pmt::pmt_t(*)()) & ::pmt::make_tuple, D(make_tuple, 0));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&)) & ::pmt::make_tuple,
          py::arg("e0"),
          D(make_tuple, 1));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&, pmt::pmt_t const&)) & ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          D(make_tuple, 2));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&, pmt::pmt_t const&, pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          D(make_tuple, 3));


    m.def(
        "make_tuple",
        (pmt::pmt_t(*)(
            pmt::pmt_t const&, pmt::pmt_t const&, pmt::pmt_t const&, pmt::pmt_t const&)) &
            ::pmt::make_tuple,
        py::arg("e0"),
        py::arg("e1"),
        py::arg("e2"),
        py::arg("e3"),
        D(make_tuple, 4));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          D(make_tuple, 5));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          py::arg("e5"),
          D(make_tuple, 6));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          py::arg("e5"),
          py::arg("e6"),
          D(make_tuple, 7));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          py::arg("e5"),
          py::arg("e6"),
          py::arg("e7"),
          D(make_tuple, 8));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          py::arg("e5"),
          py::arg("e6"),
          py::arg("e7"),
          py::arg("e8"),
          D(make_tuple, 9));


    m.def("make_tuple",
          (pmt::pmt_t(*)(pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&,
                         pmt::pmt_t const&)) &
              ::pmt::make_tuple,
          py::arg("e0"),
          py::arg("e1"),
          py::arg("e2"),
          py::arg("e3"),
          py::arg("e4"),
          py::arg("e5"),
          py::arg("e6"),
          py::arg("e7"),
          py::arg("e8"),
          py::arg("e9"),
          D(make_tuple, 10));


    m.def("to_tuple", &::pmt::to_tuple, py::arg("x"), D(to_tuple));


    m.def("tuple_ref", &::pmt::tuple_ref, py::arg("tuple"), py::arg("k"), D(tuple_ref));


    m.def("is_vector", &::pmt::is_vector, py::arg("x"), D(is_vector));


    m.def("make_vector",
          &::pmt::make_vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_vector));


    m.def(
        "vector_ref", &::pmt::vector_ref, py::arg("vector"), py::arg("k"), D(vector_ref));


    m.def("vector_set",
          &::pmt::vector_set,
          py::arg("vector"),
          py::arg("k"),
          py::arg("obj"),
          D(vector_set));


    m.def("vector_fill",
          &::pmt::vector_fill,
          py::arg("vector"),
          py::arg("fill"),
          D(vector_fill));


    m.def("is_blob", &::pmt::is_blob, py::arg("x"), D(is_blob));


    m.def("make_blob", &::pmt::make_blob, py::arg("buf"), py::arg("len"), D(make_blob));


    m.def("blob_data", &::pmt::blob_data, py::arg("blob"), D(blob_data));


    m.def("blob_length", &::pmt::blob_length, py::arg("blob"), D(blob_length));


    m.def("is_uniform_vector",
          &::pmt::is_uniform_vector,
          py::arg("x"),
          D(is_uniform_vector));


    m.def("is_u8vector", &::pmt::is_u8vector, py::arg("x"), D(is_u8vector));


    m.def("is_s8vector", &::pmt::is_s8vector, py::arg("x"), D(is_s8vector));


    m.def("is_u16vector", &::pmt::is_u16vector, py::arg("x"), D(is_u16vector));


    m.def("is_s16vector", &::pmt::is_s16vector, py::arg("x"), D(is_s16vector));


    m.def("is_u32vector", &::pmt::is_u32vector, py::arg("x"), D(is_u32vector));


    m.def("is_s32vector", &::pmt::is_s32vector, py::arg("x"), D(is_s32vector));


    m.def("is_u64vector", &::pmt::is_u64vector, py::arg("x"), D(is_u64vector));


    m.def("is_s64vector", &::pmt::is_s64vector, py::arg("x"), D(is_s64vector));


    m.def("is_f32vector", &::pmt::is_f32vector, py::arg("x"), D(is_f32vector));


    m.def("is_f64vector", &::pmt::is_f64vector, py::arg("x"), D(is_f64vector));


    m.def("is_c32vector", &::pmt::is_c32vector, py::arg("x"), D(is_c32vector));


    m.def("is_c64vector", &::pmt::is_c64vector, py::arg("x"), D(is_c64vector));


    m.def("uniform_vector_itemsize",
          &::pmt::uniform_vector_itemsize,
          py::arg("x"),
          D(uniform_vector_itemsize));


    m.def("make_u8vector",
          &::pmt::make_u8vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_u8vector));


    m.def("make_s8vector",
          &::pmt::make_s8vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_s8vector));


    m.def("make_u16vector",
          &::pmt::make_u16vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_u16vector));


    m.def("make_s16vector",
          &::pmt::make_s16vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_s16vector));


    m.def("make_u32vector",
          &::pmt::make_u32vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_u32vector));


    m.def("make_s32vector",
          &::pmt::make_s32vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_s32vector));


    m.def("make_u64vector",
          &::pmt::make_u64vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_u64vector));


    m.def("make_s64vector",
          &::pmt::make_s64vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_s64vector));


    m.def("make_f32vector",
          &::pmt::make_f32vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_f32vector));


    m.def("make_f64vector",
          &::pmt::make_f64vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_f64vector));


    m.def("make_c32vector",
          &::pmt::make_c32vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_c32vector));


    m.def("make_c64vector",
          &::pmt::make_c64vector,
          py::arg("k"),
          py::arg("fill"),
          D(make_c64vector));


    m.def("init_u8vector",
          (pmt::pmt_t(*)(size_t, uint8_t const*)) & ::pmt::init_u8vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u8vector, 0));


    m.def("init_u8vector",
          (pmt::pmt_t(*)(
              size_t, std::vector<unsigned char, std::allocator<unsigned char>> const&)) &
              ::pmt::init_u8vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u8vector, 1));


    m.def("init_s8vector",
          (pmt::pmt_t(*)(size_t, int8_t const*)) & ::pmt::init_s8vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s8vector, 0));


    m.def("init_s8vector",
          (pmt::pmt_t(*)(size_t,
                         std::vector<signed char, std::allocator<signed char>> const&)) &
              ::pmt::init_s8vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s8vector, 1));


    m.def("init_u16vector",
          (pmt::pmt_t(*)(size_t, uint16_t const*)) & ::pmt::init_u16vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u16vector, 0));


    m.def(
        "init_u16vector",
        (pmt::pmt_t(*)(
            size_t, std::vector<unsigned short, std::allocator<unsigned short>> const&)) &
            ::pmt::init_u16vector,
        py::arg("k"),
        py::arg("data"),
        D(init_u16vector, 1));


    m.def("init_s16vector",
          (pmt::pmt_t(*)(size_t, int16_t const*)) & ::pmt::init_s16vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s16vector, 0));


    m.def("init_s16vector",
          (pmt::pmt_t(*)(size_t, std::vector<short, std::allocator<short>> const&)) &
              ::pmt::init_s16vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s16vector, 1));


    m.def("init_u32vector",
          (pmt::pmt_t(*)(size_t, uint32_t const*)) & ::pmt::init_u32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u32vector, 0));


    m.def("init_u32vector",
          (pmt::pmt_t(*)(
              size_t, std::vector<unsigned int, std::allocator<unsigned int>> const&)) &
              ::pmt::init_u32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u32vector, 1));


    m.def("init_s32vector",
          (pmt::pmt_t(*)(size_t, int32_t const*)) & ::pmt::init_s32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s32vector, 0));


    m.def("init_s32vector",
          (pmt::pmt_t(*)(size_t, std::vector<int, std::allocator<int>> const&)) &
              ::pmt::init_s32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s32vector, 1));


    m.def("init_u64vector",
          (pmt::pmt_t(*)(size_t, uint64_t const*)) & ::pmt::init_u64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_u64vector, 0));


    m.def(
        "init_u64vector",
        (pmt::pmt_t(*)(size_t, std::vector<uint64_t, std::allocator<uint64_t>> const&)) &
            ::pmt::init_u64vector,
        py::arg("k"),
        py::arg("data"),
        D(init_u64vector, 1));


    m.def("init_s64vector",
          (pmt::pmt_t(*)(size_t, int64_t const*)) & ::pmt::init_s64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s64vector, 0));


    m.def("init_s64vector",
          (pmt::pmt_t(*)(size_t, std::vector<int64_t, std::allocator<int64_t>> const&)) &
              ::pmt::init_s64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_s64vector, 1));


    m.def("init_f32vector",
          (pmt::pmt_t(*)(size_t, float const*)) & ::pmt::init_f32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_f32vector, 0));


    m.def("init_f32vector",
          (pmt::pmt_t(*)(size_t, std::vector<float, std::allocator<float>> const&)) &
              ::pmt::init_f32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_f32vector, 1));


    m.def("init_f64vector",
          (pmt::pmt_t(*)(size_t, double const*)) & ::pmt::init_f64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_f64vector, 0));


    m.def("init_f64vector",
          (pmt::pmt_t(*)(size_t, std::vector<double, std::allocator<double>> const&)) &
              ::pmt::init_f64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_f64vector, 1));


    m.def("init_c32vector",
          (pmt::pmt_t(*)(size_t, std::complex<float> const*)) & ::pmt::init_c32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_c32vector, 0));


    m.def("init_c32vector",
          (pmt::pmt_t(*)(size_t,
                         std::vector<std::complex<float>,
                                     std::allocator<std::complex<float>>> const&)) &
              ::pmt::init_c32vector,
          py::arg("k"),
          py::arg("data"),
          D(init_c32vector, 1));


    m.def("init_c64vector",
          (pmt::pmt_t(*)(size_t, std::complex<double> const*)) & ::pmt::init_c64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_c64vector, 0));


    m.def("init_c64vector",
          (pmt::pmt_t(*)(size_t,
                         std::vector<std::complex<double>,
                                     std::allocator<std::complex<double>>> const&)) &
              ::pmt::init_c64vector,
          py::arg("k"),
          py::arg("data"),
          D(init_c64vector, 1));


    m.def("u8vector_ref",
          &::pmt::u8vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(u8vector_ref));


    m.def("s8vector_ref",
          &::pmt::s8vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(s8vector_ref));


    m.def("u16vector_ref",
          &::pmt::u16vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(u16vector_ref));


    m.def("s16vector_ref",
          &::pmt::s16vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(s16vector_ref));


    m.def("u32vector_ref",
          &::pmt::u32vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(u32vector_ref));


    m.def("s32vector_ref",
          &::pmt::s32vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(s32vector_ref));


    m.def("u64vector_ref",
          &::pmt::u64vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(u64vector_ref));


    m.def("s64vector_ref",
          &::pmt::s64vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(s64vector_ref));


    m.def("f32vector_ref",
          &::pmt::f32vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(f32vector_ref));


    m.def("f64vector_ref",
          &::pmt::f64vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(f64vector_ref));


    m.def("c32vector_ref",
          &::pmt::c32vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(c32vector_ref));


    m.def("c64vector_ref",
          &::pmt::c64vector_ref,
          py::arg("v"),
          py::arg("k"),
          D(c64vector_ref));


    m.def("u8vector_set",
          &::pmt::u8vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(u8vector_set));


    m.def("s8vector_set",
          &::pmt::s8vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(s8vector_set));


    m.def("u16vector_set",
          &::pmt::u16vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(u16vector_set));


    m.def("s16vector_set",
          &::pmt::s16vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(s16vector_set));


    m.def("u32vector_set",
          &::pmt::u32vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(u32vector_set));


    m.def("s32vector_set",
          &::pmt::s32vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(s32vector_set));


    m.def("u64vector_set",
          &::pmt::u64vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(u64vector_set));


    m.def("s64vector_set",
          &::pmt::s64vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(s64vector_set));


    m.def("f32vector_set",
          &::pmt::f32vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(f32vector_set));


    m.def("f64vector_set",
          &::pmt::f64vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(f64vector_set));


    m.def("c32vector_set",
          &::pmt::c32vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(c32vector_set));


    m.def("c64vector_set",
          &::pmt::c64vector_set,
          py::arg("v"),
          py::arg("k"),
          py::arg("x"),
          D(c64vector_set));


    m.def("uniform_vector_elements",
          &::pmt::uniform_vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(uniform_vector_elements));


    m.def("u8vector_elements",
          (uint8_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::u8vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(u8vector_elements, 0));


    m.def("s8vector_elements",
          (int8_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::s8vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(s8vector_elements, 0));


    m.def("u16vector_elements",
          (uint16_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::u16vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(u16vector_elements, 0));


    m.def("s16vector_elements",
          (int16_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::s16vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(s16vector_elements, 0));


    m.def("u32vector_elements",
          (uint32_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::u32vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(u32vector_elements, 0));


    m.def("s32vector_elements",
          (int32_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::s32vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(s32vector_elements, 0));


    m.def("u64vector_elements",
          (uint64_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::u64vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(u64vector_elements, 0));


    m.def("s64vector_elements",
          (int64_t const* (*)(pmt::pmt_t, size_t&)) & ::pmt::s64vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(s64vector_elements, 0));


    m.def("f32vector_elements",
          (float const* (*)(pmt::pmt_t, size_t&)) & ::pmt::f32vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(f32vector_elements, 0));


    m.def("f64vector_elements",
          (double const* (*)(pmt::pmt_t, size_t&)) & ::pmt::f64vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(f64vector_elements, 0));


    m.def("c32vector_elements",
          (std::complex<float> const* (*)(pmt::pmt_t, size_t&)) &
              ::pmt::c32vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(c32vector_elements, 0));


    m.def("c64vector_elements",
          (std::complex<double> const* (*)(pmt::pmt_t, size_t&)) &
              ::pmt::c64vector_elements,
          py::arg("v"),
          py::arg("len"),
          D(c64vector_elements, 0));

    m.def("u8vector_elements",
          (std::vector<unsigned char, std::allocator<unsigned char>> const (*)(
              pmt::pmt_t)) &
              ::pmt::u8vector_elements,
          py::arg("v"),
          D(u8vector_elements, 1));


    m.def("s8vector_elements",
          (std::vector<signed char, std::allocator<signed char>> const (*)(pmt::pmt_t)) &
              ::pmt::s8vector_elements,
          py::arg("v"),
          D(s8vector_elements, 1));


    m.def("u16vector_elements",
          (std::vector<unsigned short, std::allocator<unsigned short>> const (*)(
              pmt::pmt_t)) &
              ::pmt::u16vector_elements,
          py::arg("v"),
          D(u16vector_elements, 1));


    m.def("s16vector_elements",
          (std::vector<short, std::allocator<short>> const (*)(pmt::pmt_t)) &
              ::pmt::s16vector_elements,
          py::arg("v"),
          D(s16vector_elements, 1));


    m.def(
        "u32vector_elements",
        (std::vector<unsigned int, std::allocator<unsigned int>> const (*)(pmt::pmt_t)) &
            ::pmt::u32vector_elements,
        py::arg("v"),
        D(u32vector_elements, 1));


    m.def("s32vector_elements",
          (std::vector<int, std::allocator<int>> const (*)(pmt::pmt_t)) &
              ::pmt::s32vector_elements,
          py::arg("v"),
          D(s32vector_elements, 1));


    m.def("u64vector_elements",
          (std::vector<uint64_t, std::allocator<uint64_t>> const (*)(pmt::pmt_t)) &
              ::pmt::u64vector_elements,
          py::arg("v"),
          D(u64vector_elements, 1));


    m.def("s64vector_elements",
          (std::vector<int64_t, std::allocator<int64_t>> const (*)(pmt::pmt_t)) &
              ::pmt::s64vector_elements,
          py::arg("v"),
          D(s64vector_elements, 1));


    m.def("f32vector_elements",
          (std::vector<float, std::allocator<float>> const (*)(pmt::pmt_t)) &
              ::pmt::f32vector_elements,
          py::arg("v"),
          D(f32vector_elements, 1));


    m.def("f64vector_elements",
          (std::vector<double, std::allocator<double>> const (*)(pmt::pmt_t)) &
              ::pmt::f64vector_elements,
          py::arg("v"),
          D(f64vector_elements, 1));


    m.def(
        "c32vector_elements",
        (std::vector<std::complex<float>, std::allocator<std::complex<float>>> const (*)(
            pmt::pmt_t)) &
            ::pmt::c32vector_elements,
        py::arg("v"),
        D(c32vector_elements, 1));


    m.def("c64vector_elements",
          (std::vector<std::complex<double>,
                       std::allocator<std::complex<double>>> const (*)(pmt::pmt_t)) &
              ::pmt::c64vector_elements,
          py::arg("v"),
          D(c64vector_elements, 1));

    m.def("uniform_vector_writable_elements",
          &::pmt::uniform_vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(uniform_vector_writable_elements));


    m.def("u8vector_writable_elements",
          &::pmt::u8vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(u8vector_writable_elements));


    m.def("s8vector_writable_elements",
          &::pmt::s8vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(s8vector_writable_elements));


    m.def("u16vector_writable_elements",
          &::pmt::u16vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(u16vector_writable_elements));


    m.def("s16vector_writable_elements",
          &::pmt::s16vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(s16vector_writable_elements));


    m.def("u32vector_writable_elements",
          &::pmt::u32vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(u32vector_writable_elements));


    m.def("s32vector_writable_elements",
          &::pmt::s32vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(s32vector_writable_elements));


    m.def("u64vector_writable_elements",
          &::pmt::u64vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(u64vector_writable_elements));


    m.def("s64vector_writable_elements",
          &::pmt::s64vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(s64vector_writable_elements));


    m.def("f32vector_writable_elements",
          &::pmt::f32vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(f32vector_writable_elements));


    m.def("f64vector_writable_elements",
          &::pmt::f64vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(f64vector_writable_elements));


    m.def("c32vector_writable_elements",
          &::pmt::c32vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(c32vector_writable_elements));


    m.def("c64vector_writable_elements",
          &::pmt::c64vector_writable_elements,
          py::arg("v"),
          py::arg("len"),
          D(c64vector_writable_elements));


    m.def("is_dict", &::pmt::is_dict, py::arg("obj"), D(is_dict));


    m.def("make_dict", &::pmt::make_dict, D(make_dict));


    m.def("dict_add",
          &::pmt::dict_add,
          py::arg("dict"),
          py::arg("key"),
          py::arg("value"),
          D(dict_add));


    m.def("dict_delete",
          &::pmt::dict_delete,
          py::arg("dict"),
          py::arg("key"),
          D(dict_delete));


    m.def("dict_has_key",
          &::pmt::dict_has_key,
          py::arg("dict"),
          py::arg("key"),
          D(dict_has_key));


    m.def("dict_ref",
          &::pmt::dict_ref,
          py::arg("dict"),
          py::arg("key"),
          py::arg("not_found"),
          D(dict_ref));


    m.def("dict_items", &::pmt::dict_items, py::arg("dict"), D(dict_items));


    m.def("dict_keys", &::pmt::dict_keys, py::arg("dict"), D(dict_keys));


    m.def("dict_update",
          &::pmt::dict_update,
          py::arg("dict1"),
          py::arg("dict2"),
          D(dict_update));


    m.def("dict_values", &::pmt::dict_values, py::arg("dict"), D(dict_values));


    m.def("is_any", &::pmt::is_any, py::arg("obj"), D(is_any));


    m.def("make_any", &::pmt::make_any, py::arg("any"), D(make_any));


    m.def("any_ref", &::pmt::any_ref, py::arg("obj"), D(any_ref));


    m.def("any_set", &::pmt::any_set, py::arg("obj"), py::arg("any"), D(any_set));

    // m.def("is_msg_accepter",&pmt::is_msg_accepter,
    //     py::arg("obj")
    // );
    // m.def("make_msg_accepter",&pmt::make_msg_accepter,
    //     py::arg("ma")
    // );
    // m.def("msg_accepter_ref",&pmt::msg_accepter_ref,
    //     py::arg("obj")
    // );
    m.def("is_pdu", &::pmt::is_pdu, py::arg("obj"), D(is_pdu));


    m.def("eq", &::pmt::eq, py::arg("x"), py::arg("y"), D(eq));


    m.def("eqv", &::pmt::eqv, py::arg("x"), py::arg("y"), D(eqv));


    m.def("equal", &::pmt::equal, py::arg("x"), py::arg("y"), D(equal));


    m.def("assq", &::pmt::assq, py::arg("obj"), py::arg("alist"), D(assq));


    m.def("assv", &::pmt::assv, py::arg("obj"), py::arg("alist"), D(assv));


    m.def("assoc", &::pmt::assoc, py::arg("obj"), py::arg("alist"), D(assoc));


    m.def("map", &::pmt::map, py::arg("proc"), py::arg("list"), D(map));


    m.def("reverse", &::pmt::reverse, py::arg("list"), D(reverse));


    m.def("reverse_x", &::pmt::reverse_x, py::arg("list"), D(reverse_x));


    m.def("acons", &::pmt::acons, py::arg("x"), py::arg("y"), py::arg("a"), D(acons));


    m.def("nth", &::pmt::nth, py::arg("n"), py::arg("list"), D(nth));


    m.def("nthcdr", &::pmt::nthcdr, py::arg("n"), py::arg("list"), D(nthcdr));


    m.def("memq", &::pmt::memq, py::arg("obj"), py::arg("list"), D(memq));


    m.def("memv", &::pmt::memv, py::arg("obj"), py::arg("list"), D(memv));


    m.def("member", &::pmt::member, py::arg("obj"), py::arg("list"), D(member));


    m.def("subsetp", &::pmt::subsetp, py::arg("list1"), py::arg("list2"), D(subsetp));


    m.def("list1", &::pmt::list1, py::arg("x1"), D(list1));


    m.def("list2", &::pmt::list2, py::arg("x1"), py::arg("x2"), D(list2));


    m.def("list3", &::pmt::list3, py::arg("x1"), py::arg("x2"), py::arg("x3"), D(list3));


    m.def("list4",
          &::pmt::list4,
          py::arg("x1"),
          py::arg("x2"),
          py::arg("x3"),
          py::arg("x4"),
          D(list4));


    m.def("list5",
          &::pmt::list5,
          py::arg("x1"),
          py::arg("x2"),
          py::arg("x3"),
          py::arg("x4"),
          py::arg("x5"),
          D(list5));


    m.def("list6",
          &::pmt::list6,
          py::arg("x1"),
          py::arg("x2"),
          py::arg("x3"),
          py::arg("x4"),
          py::arg("x5"),
          py::arg("x6"),
          D(list6));


    m.def("list_add", &::pmt::list_add, py::arg("list"), py::arg("item"), D(list_add));


    m.def("list_rm", &::pmt::list_rm, py::arg("list"), py::arg("item"), D(list_rm));


    m.def("list_has", &::pmt::list_has, py::arg("list"), py::arg("item"), D(list_has));


    m.def("is_eof_object", &::pmt::is_eof_object, py::arg("obj"), D(is_eof_object));


    m.def("read", &::pmt::read, py::arg("port"), D(read));


    m.def("write", &::pmt::write, py::arg("obj"), py::arg("port"), D(write));


    m.def("write_string", &::pmt::write_string, py::arg("obj"), D(write_string));


    m.def("print", &::pmt::print, py::arg("v"), D(print));


    m.def("serialize", &::pmt::serialize, py::arg("obj"), py::arg("sink"), D(serialize));


    m.def("deserialize", &::pmt::deserialize, py::arg("source"), D(deserialize));


    m.def("dump_sizeof", &::pmt::dump_sizeof, D(dump_sizeof));

    m.def("length", &pmt::length, py::arg("v"));

    // pybind11 needs explicit conversion to handle non-utf8 strings
    m.def(
        "serialize_str",
        [](pmt::pmt_t obj) {
            std::string s = serialize_str(obj);
            return py::bytes(s); // Return the data without transcoding
        },
        py::arg("obj"),
        D(serialize_str));

    m.def("deserialize_str", &pmt::deserialize_str, py::arg("str"), D(deserialize_str));
}
