// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

//    along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

//go:build !windows

package util

import (
	"os"
	"os/exec"
	"syscall"
)

func SetSysProcAttribute(cmd *exec.Cmd) {
	cmd.SysProcAttr = &syscall.SysProcAttr{Setpgid: true}
}

func kill(p *os.Process) error {
	return syscall.Kill(-p.Pid, syscall.SIGKILL)
}
