package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ConnectorGovernanceRuleClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type ConnectorGovernanceRuleClient struct {
	BaseClient
}

// NewConnectorGovernanceRuleClient creates an instance of the ConnectorGovernanceRuleClient client.
func NewConnectorGovernanceRuleClient(subscriptionID string) ConnectorGovernanceRuleClient {
	return NewConnectorGovernanceRuleClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewConnectorGovernanceRuleClientWithBaseURI creates an instance of the ConnectorGovernanceRuleClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewConnectorGovernanceRuleClientWithBaseURI(baseURI string, subscriptionID string) ConnectorGovernanceRuleClient {
	return ConnectorGovernanceRuleClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List get a list of all relevant governanceRules over a security connector level scope
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// securityConnectorName - the security connector name.
func (client ConnectorGovernanceRuleClient) List(ctx context.Context, resourceGroupName string, securityConnectorName string) (result GovernanceRuleListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorGovernanceRuleClient.List")
		defer func() {
			sc := -1
			if result.grl.Response.Response != nil {
				sc = result.grl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.ConnectorGovernanceRuleClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, securityConnectorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.grl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "List", resp, "Failure sending request")
		return
	}

	result.grl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "List", resp, "Failure responding to request")
		return
	}
	if result.grl.hasNextLink() && result.grl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ConnectorGovernanceRuleClient) ListPreparer(ctx context.Context, resourceGroupName string, securityConnectorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"securityConnectorName": autorest.Encode("path", securityConnectorName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/providers/Microsoft.Security/governanceRules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ConnectorGovernanceRuleClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ConnectorGovernanceRuleClient) ListResponder(resp *http.Response) (result GovernanceRuleList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ConnectorGovernanceRuleClient) listNextResults(ctx context.Context, lastResults GovernanceRuleList) (result GovernanceRuleList, err error) {
	req, err := lastResults.governanceRuleListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRuleClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ConnectorGovernanceRuleClient) ListComplete(ctx context.Context, resourceGroupName string, securityConnectorName string) (result GovernanceRuleListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorGovernanceRuleClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, securityConnectorName)
	return
}
