// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
///////////////////////////////////////////////////////////////////////////////

// Protos for Module-Lattice Digital Signature Algorithm (ML-DSA).
// See https://csrc.nist.gov/pubs/fips/204/final.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: ml_dsa.proto

package ml_dsa_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MlDsaInstance int32

const (
	MlDsaInstance_ML_DSA_UNKNOWN_INSTANCE MlDsaInstance = 0
	MlDsaInstance_ML_DSA_65               MlDsaInstance = 1
)

// Enum value maps for MlDsaInstance.
var (
	MlDsaInstance_name = map[int32]string{
		0: "ML_DSA_UNKNOWN_INSTANCE",
		1: "ML_DSA_65",
	}
	MlDsaInstance_value = map[string]int32{
		"ML_DSA_UNKNOWN_INSTANCE": 0,
		"ML_DSA_65":               1,
	}
)

func (x MlDsaInstance) Enum() *MlDsaInstance {
	p := new(MlDsaInstance)
	*p = x
	return p
}

func (x MlDsaInstance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MlDsaInstance) Descriptor() protoreflect.EnumDescriptor {
	return file_ml_dsa_proto_enumTypes[0].Descriptor()
}

func (MlDsaInstance) Type() protoreflect.EnumType {
	return &file_ml_dsa_proto_enumTypes[0]
}

func (x MlDsaInstance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MlDsaInstance.Descriptor instead.
func (MlDsaInstance) EnumDescriptor() ([]byte, []int) {
	return file_ml_dsa_proto_rawDescGZIP(), []int{0}
}

type MlDsaParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	MlDsaInstance MlDsaInstance `protobuf:"varint,1,opt,name=ml_dsa_instance,json=mlDsaInstance,proto3,enum=google.crypto.tink.MlDsaInstance" json:"ml_dsa_instance,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MlDsaParams) Reset() {
	*x = MlDsaParams{}
	mi := &file_ml_dsa_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MlDsaParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MlDsaParams) ProtoMessage() {}

func (x *MlDsaParams) ProtoReflect() protoreflect.Message {
	mi := &file_ml_dsa_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MlDsaParams.ProtoReflect.Descriptor instead.
func (*MlDsaParams) Descriptor() ([]byte, []int) {
	return file_ml_dsa_proto_rawDescGZIP(), []int{0}
}

func (x *MlDsaParams) GetMlDsaInstance() MlDsaInstance {
	if x != nil {
		return x.MlDsaInstance
	}
	return MlDsaInstance_ML_DSA_UNKNOWN_INSTANCE
}

type MlDsaKeyFormat struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	Params        *MlDsaParams `protobuf:"bytes,2,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MlDsaKeyFormat) Reset() {
	*x = MlDsaKeyFormat{}
	mi := &file_ml_dsa_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MlDsaKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MlDsaKeyFormat) ProtoMessage() {}

func (x *MlDsaKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_ml_dsa_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MlDsaKeyFormat.ProtoReflect.Descriptor instead.
func (*MlDsaKeyFormat) Descriptor() ([]byte, []int) {
	return file_ml_dsa_proto_rawDescGZIP(), []int{1}
}

func (x *MlDsaKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *MlDsaKeyFormat) GetParams() *MlDsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.MlDsaPublicKey
type MlDsaPublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required.
	KeyValue []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"`
	// Required.
	Params        *MlDsaParams `protobuf:"bytes,3,opt,name=params,proto3" json:"params,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MlDsaPublicKey) Reset() {
	*x = MlDsaPublicKey{}
	mi := &file_ml_dsa_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MlDsaPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MlDsaPublicKey) ProtoMessage() {}

func (x *MlDsaPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_ml_dsa_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MlDsaPublicKey.ProtoReflect.Descriptor instead.
func (*MlDsaPublicKey) Descriptor() ([]byte, []int) {
	return file_ml_dsa_proto_rawDescGZIP(), []int{2}
}

func (x *MlDsaPublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *MlDsaPublicKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *MlDsaPublicKey) GetParams() *MlDsaParams {
	if x != nil {
		return x.Params
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.MlDsaPrivateKey
type MlDsaPrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Required. Note that this contains the seed used to generate the private
	// key, not the private key itself.
	KeyValue []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"`
	// The corresponding public key.
	PublicKey     *MlDsaPublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MlDsaPrivateKey) Reset() {
	*x = MlDsaPrivateKey{}
	mi := &file_ml_dsa_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MlDsaPrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MlDsaPrivateKey) ProtoMessage() {}

func (x *MlDsaPrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_ml_dsa_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MlDsaPrivateKey.ProtoReflect.Descriptor instead.
func (*MlDsaPrivateKey) Descriptor() ([]byte, []int) {
	return file_ml_dsa_proto_rawDescGZIP(), []int{3}
}

func (x *MlDsaPrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *MlDsaPrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *MlDsaPrivateKey) GetPublicKey() *MlDsaPublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

var File_ml_dsa_proto protoreflect.FileDescriptor

const file_ml_dsa_proto_rawDesc = "" +
	"\n" +
	"\fml_dsa.proto\x12\x12google.crypto.tink\"X\n" +
	"\vMlDsaParams\x12I\n" +
	"\x0fml_dsa_instance\x18\x01 \x01(\x0e2!.google.crypto.tink.MlDsaInstanceR\rmlDsaInstance\"c\n" +
	"\x0eMlDsaKeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x127\n" +
	"\x06params\x18\x02 \x01(\v2\x1f.google.crypto.tink.MlDsaParamsR\x06params\"\x80\x01\n" +
	"\x0eMlDsaPublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\x127\n" +
	"\x06params\x18\x03 \x01(\v2\x1f.google.crypto.tink.MlDsaParamsR\x06params\"\x8b\x01\n" +
	"\x0fMlDsaPrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\x12A\n" +
	"\n" +
	"public_key\x18\x03 \x01(\v2\".google.crypto.tink.MlDsaPublicKeyR\tpublicKey*;\n" +
	"\rMlDsaInstance\x12\x1b\n" +
	"\x17ML_DSA_UNKNOWN_INSTANCE\x10\x00\x12\r\n" +
	"\tML_DSA_65\x10\x01BV\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z4github.com/tink-crypto/tink-go/v2/proto/ml_dsa_protob\x06proto3"

var (
	file_ml_dsa_proto_rawDescOnce sync.Once
	file_ml_dsa_proto_rawDescData []byte
)

func file_ml_dsa_proto_rawDescGZIP() []byte {
	file_ml_dsa_proto_rawDescOnce.Do(func() {
		file_ml_dsa_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_ml_dsa_proto_rawDesc), len(file_ml_dsa_proto_rawDesc)))
	})
	return file_ml_dsa_proto_rawDescData
}

var file_ml_dsa_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_ml_dsa_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_ml_dsa_proto_goTypes = []any{
	(MlDsaInstance)(0),      // 0: google.crypto.tink.MlDsaInstance
	(*MlDsaParams)(nil),     // 1: google.crypto.tink.MlDsaParams
	(*MlDsaKeyFormat)(nil),  // 2: google.crypto.tink.MlDsaKeyFormat
	(*MlDsaPublicKey)(nil),  // 3: google.crypto.tink.MlDsaPublicKey
	(*MlDsaPrivateKey)(nil), // 4: google.crypto.tink.MlDsaPrivateKey
}
var file_ml_dsa_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.MlDsaParams.ml_dsa_instance:type_name -> google.crypto.tink.MlDsaInstance
	1, // 1: google.crypto.tink.MlDsaKeyFormat.params:type_name -> google.crypto.tink.MlDsaParams
	1, // 2: google.crypto.tink.MlDsaPublicKey.params:type_name -> google.crypto.tink.MlDsaParams
	3, // 3: google.crypto.tink.MlDsaPrivateKey.public_key:type_name -> google.crypto.tink.MlDsaPublicKey
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_ml_dsa_proto_init() }
func file_ml_dsa_proto_init() {
	if File_ml_dsa_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_ml_dsa_proto_rawDesc), len(file_ml_dsa_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ml_dsa_proto_goTypes,
		DependencyIndexes: file_ml_dsa_proto_depIdxs,
		EnumInfos:         file_ml_dsa_proto_enumTypes,
		MessageInfos:      file_ml_dsa_proto_msgTypes,
	}.Build()
	File_ml_dsa_proto = out.File
	file_ml_dsa_proto_goTypes = nil
	file_ml_dsa_proto_depIdxs = nil
}
