#!/usr/bin/perl

# File         : generate.pl
# Author       : Bryan Carpenter
# Created      : Thu Jul 15 10:44:32 BST 2004
# Revision     : $Revision: 1.4 $
# Updated      : $Date: 2005/08/16 21:44:02 $

  #logical types


  # Numeric types
  @ntypes = ('byte', 'short', 'int', 'long', 'char', 'float', 'double') ;
  @nTypes = ('Byte', 'Short', 'Int', 'Long', 'Char', 'Float', 'Double') ;
  @nTYPES = ('BYTE', 'SHORT', 'INT', 'LONG', 'CHAR', 'FLOAT', 'DOUBLE') ;

  # Logical types ..only boolean ..and even boolean is represented
  @ltypes = ('boolean');
  @lTypes = ('Boolean');
  @lTYPES = ('BOOLEAN');

  # in Java bit-wise operations cannot be applied to double and float ...
  @btypes = ('byte', 'short', 'int', 'long', 'char');
  @bTypes = ('Byte', 'Short', 'Int', 'Long', 'Char');
  @bTYPES = ('BYTE', 'SHORT', 'INT', 'LONG', 'CHAR');

  # another category for minloc and maxloc operations ...
  @mtypes = ('short', 'int', 'long', 'float', 'double');
  @mTypes = ('Short', 'Int', 'Long', 'Float', 'Double');
  @mTYPES = ('SHORT', 'INT', 'LONG', 'FLOAT', 'DOUBLE');

  @smallest = ('Byte.MIN_VALUE', 'Short.MIN_VALUE', 'Integer.MIN_VALUE',
               'Long.MIN_VALUE', 'Character.MIN_VALUE',
               'Float.NEGATIVE_INFINITY', 'Double.NEGATIVE_INFINITY') ;

  @largest  = ('Byte.MAX_VALUE', 'Short.MAX_VALUE', 'Integer.MAX_VALUE',
               'Long.MAX_VALUE', 'Character.MAX_VALUE',
               'Float.POSITIVE_INFINITY', 'Double.POSITIVE_INFINITY') ;


  # Primitive types

  @ptypes = (@ntypes, 'boolean') ;
  @pTypes = (@nTypes, 'Boolean') ;
  @pTYPES = (@nTYPES, 'BOOLEAN') ;


  # General types

  @types = (@ptypes, 'Object') ;
  @Types = (@pTypes, 'Object') ;
  @TYPES = (@pTYPES, 'OBJECT') ;


  # Root names for classes generated by simple templates over primitive types

  #@mroots = ('Minloc','Maxloc') ;

  @lroots = ('Land', 'Lor', 'Lxor') ;

  @nroots = ('Max','Min','Sum','Prod');

  @broots = ('Bxor','Bor','Band');

  # Root names for classes generated by simple templates over general types

  @groots = ('SimplePacker', 'MultistridedPacker', 'GatherPacker');

  #foreach $root (@mroots) {
   #   $template = "${root}Type.java.in" ;
   #   for ($i = 0 ; $i < @mtypes ; $i++) {
    #      $type = $mtypes [$i] ;
     #     $Type = $mTypes [$i] ;
      #    $TYPE = $mTYPES [$i] ;
       #   makeSimple("${root}${Type}", $type, $Type, $TYPE, 'false',
        #             $template) ;
      #}
  #}

  foreach $root (@lroots) {
      $template = "${root}Type.java.in" ;
      for ($i = 0 ; $i < @ltypes ; $i++) {
          $type = $ltypes [$i] ;
          $Type = $lTypes [$i] ;
          $TYPE = $lTYPES [$i] ;
          makeSimple("${root}${Type}", $type, $Type, $TYPE, 'false',
                     $template) ;
      }
  }

  foreach $root (@broots) {
      $template = "${root}Type.java.in" ;
      for ($i = 0 ; $i < @btypes ; $i++) {
          $type = $btypes [$i] ;
          $Type = $bTypes [$i] ;
          $TYPE = $bTYPES [$i] ;
          makeSimple("${root}${Type}", $type, $Type, $TYPE, 'false',
                     $template) ;
      }
  }

  foreach $root (@nroots) {
      $template = "${root}Type.java.in" ;
      for ($i = 0 ; $i < @ntypes ; $i++) {
          $type = $ntypes [$i] ;
          $Type = $nTypes [$i] ;
          $TYPE = $nTYPES [$i] ;
          makeSimple("${root}${Type}", $type, $Type, $TYPE, 'false',
                     $template) ;
      }
  }

  foreach $root (@groots) {

      $template = "${root}Type.java.in" ;

      for ($i = 0 ; $i < @ptypes ; $i++) {

          $type = $ptypes [$i] ;
          $Type = $pTypes [$i] ;
          $TYPE = $pTYPES [$i] ;

          makeSimple("${root}${Type}", $type, $Type, $TYPE, 'false',
                     $template) ;
      }

      makeSimple("${root}Object", 'Object', 'Object', 'OBJECT', 'true',
                 $template) ;
  }


  sub makeSimple {

      local $name = $_[0] ;
      local $type = $_[1] ;
      local $Type = $_[2] ;
      local $TYPE = $_[3] ;
      local $isObject = $_[4] ;
      local $template = $_[5] ;

      local $target = "${name}.java" ;

      open(TEMPLATE, $template) or die "Can't open $template: $!\n" ;
      open(TARGET, ">$target")  or die "Can't create $target: $!\n" ;

      print TARGET "/* This file generated automatically ",
                   "from template $template. */\n" ;

      while($line = <TEMPLATE>) {
          $line =~ s/\@type\@/${type}/g ;
          $line =~ s/\@Type\@/${Type}/g ;
          $line =~ s/\@TYPE\@/${TYPE}/g ;
          $line =~ s/\@isObject\@/${isObject}/g ;
          if($isObject eq 'true') {
              $line =~
                  s/\@READBUF\(([^\)]*)\)\@/((mpjbuf.Buffer) $1)/g ;
              $line =~
                  s/\@WRITEBUF\(([^\)]*)\)\@/((mpjbuf.Buffer) $1)/g ;
          }
          else {
              $line =~ s/\@READBUF\(([^\)]*)\)\@/$1/g ;
              $line =~ s/\@WRITEBUF\(([^\)]*)\)\@/$1/g ;
          }
          print TARGET $line ;
      }

      close TARGET ;
      close TEMPLATE ;
  }

