
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUrl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QUrl>
#include <QUrlQuery>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUrl

//  Constructor QUrl::QUrl()


static void _init_ctor_QUrl_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl *> (new QUrl ());
}


//  Constructor QUrl::QUrl(const QUrl &copy)


static void _init_ctor_QUrl_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_1701 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QUrl *> (new QUrl (arg1));
}


//  Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_ctor_QUrl_3970 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_3970 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  ret.write<QUrl *> (new QUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}


// QUrl QUrl::adjusted(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_adjusted_c7571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_adjusted_c7571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg1 = gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap);
  ret.write<QUrl > ((QUrl)((QUrl *)cls)->adjusted (arg1));
}


// QString QUrl::authority(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_authority_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::PrettyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_authority_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::PrettyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->authority (arg1));
}


// void QUrl::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->clear ();
}


// void QUrl::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->detach ();
}


// QString QUrl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->errorString ());
}


// QString QUrl::fileName(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_fileName_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FullyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileName_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::FullyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->fileName (arg1));
}


// QString QUrl::fragment(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_fragment_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::PrettyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fragment_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::PrettyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->fragment (arg1));
}


// bool QUrl::hasFragment()


static void _init_f_hasFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->hasFragment ());
}


// bool QUrl::hasQuery()


static void _init_f_hasQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasQuery_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->hasQuery ());
}


// QString QUrl::host(QFlags<QUrl::ComponentFormattingOption>)


static void _init_f_host_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QUrl::FullyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_host_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::FullyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->host (arg1));
}


// bool QUrl::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isDetached ());
}


// bool QUrl::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isEmpty ());
}


// bool QUrl::isLocalFile()


static void _init_f_isLocalFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLocalFile_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isLocalFile ());
}


// bool QUrl::isParentOf(const QUrl &url)


static void _init_f_isParentOf_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isParentOf_c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QUrl *)cls)->isParentOf (arg1));
}


// bool QUrl::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isRelative ());
}


// bool QUrl::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isValid ());
}


// bool QUrl::matches(const QUrl &url, QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_matches_c9164 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_matches_c9164 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg2 = gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap);
  ret.write<bool > ((bool)((QUrl *)cls)->matches (arg1, arg2));
}


// bool QUrl::operator !=(const QUrl &url)


static void _init_f_operator_excl__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator != (arg1));
}


// bool QUrl::operator <(const QUrl &url)


static void _init_f_operator_lt__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator < (arg1));
}


// QUrl &QUrl::operator =(const QUrl &copy)


static void _init_f_operator_eq__1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator = (arg1));
}


// bool QUrl::operator ==(const QUrl &url)


static void _init_f_operator_eq__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator == (arg1));
}


// QUrl &QUrl::operator=(const QString &url)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator= (arg1));
}


// QString QUrl::password(QFlags<QUrl::ComponentFormattingOption>)


static void _init_f_password_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QUrl::FullyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_password_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::FullyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->password (arg1));
}


// QString QUrl::path(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_path_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FullyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_path_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::FullyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->path (arg1));
}


// int QUrl::port(int defaultPort)


static void _init_f_port_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("defaultPort", true, "-1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_port_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<int > ((int)((QUrl *)cls)->port (arg1));
}


// QString QUrl::query(QFlags<QUrl::ComponentFormattingOption>)


static void _init_f_query_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QUrl::PrettyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_query_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::PrettyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->query (arg1));
}


// QUrl QUrl::resolved(const QUrl &relative)


static void _init_f_resolved_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("relative");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_resolved_c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QUrl > ((QUrl)((QUrl *)cls)->resolved (arg1));
}


// QString QUrl::scheme()


static void _init_f_scheme_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_scheme_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->scheme ());
}


// void QUrl::setAuthority(const QString &authority, QUrl::ParsingMode mode)


static void _init_f_setAuthority_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("authority");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAuthority_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setAuthority (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setFragment(const QString &fragment, QUrl::ParsingMode mode)


static void _init_f_setFragment_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFragment_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setFragment (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setHost(const QString &host, QUrl::ParsingMode mode)


static void _init_f_setHost_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::DecodedMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setHost_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::DecodedMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setHost (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setPassword(const QString &password, QUrl::ParsingMode mode)


static void _init_f_setPassword_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("password");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::DecodedMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPassword_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::DecodedMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPassword (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setPath(const QString &path, QUrl::ParsingMode mode)


static void _init_f_setPath_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::DecodedMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPath_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::DecodedMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPath (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setPort(int port)


static void _init_f_setPort_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPort_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPort (arg1);
}


// void QUrl::setQuery(const QString &query, QUrl::ParsingMode mode)


static void _init_f_setQuery_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQuery_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setQuery (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setQuery(const QUrlQuery &query)


static void _init_f_setQuery_2235 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QUrlQuery & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuery_2235 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrlQuery &arg1 = gsi::arg_reader<const QUrlQuery & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setQuery (arg1);
}


// void QUrl::setScheme(const QString &scheme)


static void _init_f_setScheme_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scheme");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScheme_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setScheme (arg1);
}


// void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_f_setUrl_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setUrl_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setUserInfo(const QString &userInfo, QUrl::ParsingMode mode)


static void _init_f_setUserInfo_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInfo");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setUserInfo_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUserInfo (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setUserName(const QString &userName, QUrl::ParsingMode mode)


static void _init_f_setUserName_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::DecodedMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setUserName_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::DecodedMode), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUserName (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::swap(QUrl &other)


static void _init_f_swap_1006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrl &arg1 = gsi::arg_reader<QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->swap (arg1);
}


// QString QUrl::toDisplayString(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_toDisplayString_c7571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FormattingOptions(QUrl::PrettyDecoded)");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toDisplayString_c7571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (QUrl::FormattingOptions(QUrl::PrettyDecoded), heap);
  ret.write<QString > ((QString)((QUrl *)cls)->toDisplayString (arg1));
}


// QByteArray QUrl::toEncoded(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_toEncoded_c7571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FullyEncoded");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toEncoded_c7571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (QUrl::FullyEncoded, heap);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->toEncoded (arg1));
}


// QString QUrl::toLocalFile()


static void _init_f_toLocalFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toLocalFile_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->toLocalFile ());
}


// QString QUrl::toString(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_toString_c7571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FormattingOptions(QUrl::PrettyDecoded)");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c7571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (QUrl::FormattingOptions(QUrl::PrettyDecoded), heap);
  ret.write<QString > ((QString)((QUrl *)cls)->toString (arg1));
}


// QString QUrl::url(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_url_c7571 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FormattingOptions(QUrl::PrettyDecoded)");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_url_c7571 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (QUrl::FormattingOptions(QUrl::PrettyDecoded), heap);
  ret.write<QString > ((QString)((QUrl *)cls)->url (arg1));
}


// QString QUrl::userInfo(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_userInfo_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::PrettyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_userInfo_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::PrettyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->userInfo (arg1));
}


// QString QUrl::userName(QFlags<QUrl::ComponentFormattingOption> options)


static void _init_f_userName_c4267 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::FullyDecoded");
  decl->add_arg<QFlags<QUrl::ComponentFormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_userName_c4267 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::ComponentFormattingOption> arg1 = args ? gsi::arg_reader<QFlags<QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::ComponentFormattingOption> >() (QUrl::FullyDecoded, heap);
  ret.write<QString > ((QString)((QUrl *)cls)->userName (arg1));
}


// static QString QUrl::fromAce(const QByteArray &)


static void _init_f_fromAce_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromAce_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QString > ((QString)QUrl::fromAce (arg1));
}


// static QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)


static void _init_f_fromEncoded_4254 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<QUrl > ();
}

static void _call_f_fromEncoded_4254 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  ret.write<QUrl > ((QUrl)QUrl::fromEncoded (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}


// static QUrl QUrl::fromLocalFile(const QString &localfile)


static void _init_f_fromLocalFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localfile");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromLocalFile_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QUrl > ((QUrl)QUrl::fromLocalFile (arg1));
}


// static QString QUrl::fromPercentEncoding(const QByteArray &)


static void _init_f_fromPercentEncoding_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromPercentEncoding_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  ret.write<QString > ((QString)QUrl::fromPercentEncoding (arg1));
}


// static QList<QUrl> QUrl::fromStringList(const QStringList &uris, QUrl::ParsingMode mode)


static void _init_f_fromStringList_4382 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uris");
  decl->add_arg<const QStringList & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QUrl::TolerantMode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<QList<QUrl> > ();
}

static void _call_f_fromStringList_4382 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QUrl::ParsingMode>(heap, QUrl::TolerantMode), heap);
  ret.write<QList<QUrl> > ((QList<QUrl>)QUrl::fromStringList (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}


// static QUrl QUrl::fromUserInput(const QString &userInput, const QString &workingDirectory, QFlags<QUrl::UserInputResolutionOption> options)


static void _init_f_fromUserInput_8122 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInput");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("workingDirectory", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "QUrl::DefaultResolution");
  decl->add_arg<QFlags<QUrl::UserInputResolutionOption> > (argspec_2);
  decl->set_return<QUrl > ();
}

static void _call_f_fromUserInput_8122 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  QFlags<QUrl::UserInputResolutionOption> arg3 = args ? gsi::arg_reader<QFlags<QUrl::UserInputResolutionOption> >() (args, heap) : gsi::arg_maker<QFlags<QUrl::UserInputResolutionOption> >() (QUrl::DefaultResolution, heap);
  ret.write<QUrl > ((QUrl)QUrl::fromUserInput (arg1, arg2, arg3));
}


// static QStringList QUrl::idnWhitelist()


static void _init_f_idnWhitelist_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_idnWhitelist_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QUrl::idnWhitelist ());
}


// static void QUrl::setIdnWhitelist(const QStringList &)


static void _init_f_setIdnWhitelist_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIdnWhitelist_2437 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QUrl::setIdnWhitelist (arg1);
}


// static QByteArray QUrl::toAce(const QString &)


static void _init_f_toAce_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toAce_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QByteArray > ((QByteArray)QUrl::toAce (arg1));
}


// static QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)


static void _init_f_toPercentEncoding_6427 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("exclude", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("include", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<QByteArray > ();
}

static void _call_f_toPercentEncoding_6427 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QByteArray &arg2 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() (QByteArray(), heap);
  const QByteArray &arg3 = args ? gsi::arg_reader<const QByteArray & >() (args, heap) : gsi::arg_maker<const QByteArray & >() (QByteArray(), heap);
  ret.write<QByteArray > ((QByteArray)QUrl::toPercentEncoding (arg1, arg2, arg3));
}


// static QStringList QUrl::toStringList(const QList<QUrl> &uris, QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)


static void _init_f_toStringList_9779 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uris");
  decl->add_arg<const QList<QUrl> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options", true, "QUrl::FormattingOptions(QUrl::PrettyDecoded)");
  decl->add_arg<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> > (argspec_1);
  decl->set_return<QStringList > ();
}

static void _call_f_toStringList_9779 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QUrl> &arg1 = gsi::arg_reader<const QList<QUrl> & >() (args, heap);
  QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> arg2 = args ? gsi::arg_reader<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (args, heap) : gsi::arg_maker<QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> >() (QUrl::FormattingOptions(QUrl::PrettyDecoded), heap);
  ret.write<QStringList > ((QStringList)QUrl::toStringList (arg1, arg2));
}



namespace gsi
{

static gsi::Methods methods_QUrl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl()\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_0, &_call_ctor_QUrl_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QUrl &copy)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_1701, &_call_ctor_QUrl_1701);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_3970, &_call_ctor_QUrl_3970);
  methods += new qt_gsi::GenericMethod ("adjusted", "@brief Method QUrl QUrl::adjusted(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_adjusted_c7571, &_call_f_adjusted_c7571);
  methods += new qt_gsi::GenericMethod ("authority", "@brief Method QString QUrl::authority(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_authority_c4267, &_call_f_authority_c4267);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QUrl::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("detach", "@brief Method void QUrl::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QUrl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("fileName", "@brief Method QString QUrl::fileName(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_fileName_c4267, &_call_f_fileName_c4267);
  methods += new qt_gsi::GenericMethod ("fragment", "@brief Method QString QUrl::fragment(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_fragment_c4267, &_call_f_fragment_c4267);
  methods += new qt_gsi::GenericMethod ("hasFragment", "@brief Method bool QUrl::hasFragment()\n", true, &_init_f_hasFragment_c0, &_call_f_hasFragment_c0);
  methods += new qt_gsi::GenericMethod ("hasQuery", "@brief Method bool QUrl::hasQuery()\n", true, &_init_f_hasQuery_c0, &_call_f_hasQuery_c0);
  methods += new qt_gsi::GenericMethod ("host", "@brief Method QString QUrl::host(QFlags<QUrl::ComponentFormattingOption>)\n", true, &_init_f_host_c4267, &_call_f_host_c4267);
  methods += new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QUrl::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QUrl::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isLocalFile?", "@brief Method bool QUrl::isLocalFile()\n", true, &_init_f_isLocalFile_c0, &_call_f_isLocalFile_c0);
  methods += new qt_gsi::GenericMethod ("isParentOf?", "@brief Method bool QUrl::isParentOf(const QUrl &url)\n", true, &_init_f_isParentOf_c1701, &_call_f_isParentOf_c1701);
  methods += new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QUrl::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QUrl::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("matches", "@brief Method bool QUrl::matches(const QUrl &url, QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_matches_c9164, &_call_f_matches_c9164);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QUrl::operator !=(const QUrl &url)\n", true, &_init_f_operator_excl__eq__c1701, &_call_f_operator_excl__eq__c1701);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QUrl::operator <(const QUrl &url)\n", true, &_init_f_operator_lt__c1701, &_call_f_operator_lt__c1701);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator =(const QUrl &copy)\n", false, &_init_f_operator_eq__1701, &_call_f_operator_eq__1701);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QUrl::operator ==(const QUrl &url)\n", true, &_init_f_operator_eq__eq__c1701, &_call_f_operator_eq__eq__c1701);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator=(const QString &url)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
  methods += new qt_gsi::GenericMethod ("password", "@brief Method QString QUrl::password(QFlags<QUrl::ComponentFormattingOption>)\n", true, &_init_f_password_c4267, &_call_f_password_c4267);
  methods += new qt_gsi::GenericMethod ("path", "@brief Method QString QUrl::path(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_path_c4267, &_call_f_path_c4267);
  methods += new qt_gsi::GenericMethod ("port", "@brief Method int QUrl::port(int defaultPort)\n", true, &_init_f_port_c767, &_call_f_port_c767);
  methods += new qt_gsi::GenericMethod ("query", "@brief Method QString QUrl::query(QFlags<QUrl::ComponentFormattingOption>)\n", true, &_init_f_query_c4267, &_call_f_query_c4267);
  methods += new qt_gsi::GenericMethod ("resolved", "@brief Method QUrl QUrl::resolved(const QUrl &relative)\n", true, &_init_f_resolved_c1701, &_call_f_resolved_c1701);
  methods += new qt_gsi::GenericMethod (":scheme", "@brief Method QString QUrl::scheme()\n", true, &_init_f_scheme_c0, &_call_f_scheme_c0);
  methods += new qt_gsi::GenericMethod ("setAuthority", "@brief Method void QUrl::setAuthority(const QString &authority, QUrl::ParsingMode mode)\n", false, &_init_f_setAuthority_3970, &_call_f_setAuthority_3970);
  methods += new qt_gsi::GenericMethod ("setFragment", "@brief Method void QUrl::setFragment(const QString &fragment, QUrl::ParsingMode mode)\n", false, &_init_f_setFragment_3970, &_call_f_setFragment_3970);
  methods += new qt_gsi::GenericMethod ("setHost", "@brief Method void QUrl::setHost(const QString &host, QUrl::ParsingMode mode)\n", false, &_init_f_setHost_3970, &_call_f_setHost_3970);
  methods += new qt_gsi::GenericMethod ("setPassword", "@brief Method void QUrl::setPassword(const QString &password, QUrl::ParsingMode mode)\n", false, &_init_f_setPassword_3970, &_call_f_setPassword_3970);
  methods += new qt_gsi::GenericMethod ("setPath", "@brief Method void QUrl::setPath(const QString &path, QUrl::ParsingMode mode)\n", false, &_init_f_setPath_3970, &_call_f_setPath_3970);
  methods += new qt_gsi::GenericMethod ("setPort|port=", "@brief Method void QUrl::setPort(int port)\n", false, &_init_f_setPort_767, &_call_f_setPort_767);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QUrl::setQuery(const QString &query, QUrl::ParsingMode mode)\n", false, &_init_f_setQuery_3970, &_call_f_setQuery_3970);
  methods += new qt_gsi::GenericMethod ("setQuery", "@brief Method void QUrl::setQuery(const QUrlQuery &query)\n", false, &_init_f_setQuery_2235, &_call_f_setQuery_2235);
  methods += new qt_gsi::GenericMethod ("setScheme|scheme=", "@brief Method void QUrl::setScheme(const QString &scheme)\n", false, &_init_f_setScheme_2025, &_call_f_setScheme_2025);
  methods += new qt_gsi::GenericMethod ("setUrl", "@brief Method void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)\n", false, &_init_f_setUrl_3970, &_call_f_setUrl_3970);
  methods += new qt_gsi::GenericMethod ("setUserInfo", "@brief Method void QUrl::setUserInfo(const QString &userInfo, QUrl::ParsingMode mode)\n", false, &_init_f_setUserInfo_3970, &_call_f_setUserInfo_3970);
  methods += new qt_gsi::GenericMethod ("setUserName", "@brief Method void QUrl::setUserName(const QString &userName, QUrl::ParsingMode mode)\n", false, &_init_f_setUserName_3970, &_call_f_setUserName_3970);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QUrl::swap(QUrl &other)\n", false, &_init_f_swap_1006, &_call_f_swap_1006);
  methods += new qt_gsi::GenericMethod ("toDisplayString", "@brief Method QString QUrl::toDisplayString(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_toDisplayString_c7571, &_call_f_toDisplayString_c7571);
  methods += new qt_gsi::GenericMethod ("toEncoded", "@brief Method QByteArray QUrl::toEncoded(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_toEncoded_c7571, &_call_f_toEncoded_c7571);
  methods += new qt_gsi::GenericMethod ("toLocalFile", "@brief Method QString QUrl::toLocalFile()\n", true, &_init_f_toLocalFile_c0, &_call_f_toLocalFile_c0);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QUrl::toString(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_toString_c7571, &_call_f_toString_c7571);
  methods += new qt_gsi::GenericMethod ("url", "@brief Method QString QUrl::url(QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\n", true, &_init_f_url_c7571, &_call_f_url_c7571);
  methods += new qt_gsi::GenericMethod ("userInfo", "@brief Method QString QUrl::userInfo(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_userInfo_c4267, &_call_f_userInfo_c4267);
  methods += new qt_gsi::GenericMethod ("userName", "@brief Method QString QUrl::userName(QFlags<QUrl::ComponentFormattingOption> options)\n", true, &_init_f_userName_c4267, &_call_f_userName_c4267);
  methods += new qt_gsi::GenericStaticMethod ("fromAce", "@brief Static method QString QUrl::fromAce(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromAce_2309, &_call_f_fromAce_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromEncoded", "@brief Static method QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)\nThis method is static and can be called without an instance.", &_init_f_fromEncoded_4254, &_call_f_fromEncoded_4254);
  methods += new qt_gsi::GenericStaticMethod ("fromLocalFile", "@brief Static method QUrl QUrl::fromLocalFile(const QString &localfile)\nThis method is static and can be called without an instance.", &_init_f_fromLocalFile_2025, &_call_f_fromLocalFile_2025);
  methods += new qt_gsi::GenericStaticMethod ("fromPercentEncoding", "@brief Static method QString QUrl::fromPercentEncoding(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromPercentEncoding_2309, &_call_f_fromPercentEncoding_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromStringList", "@brief Static method QList<QUrl> QUrl::fromStringList(const QStringList &uris, QUrl::ParsingMode mode)\nThis method is static and can be called without an instance.", &_init_f_fromStringList_4382, &_call_f_fromStringList_4382);
  methods += new qt_gsi::GenericStaticMethod ("fromUserInput", "@brief Static method QUrl QUrl::fromUserInput(const QString &userInput, const QString &workingDirectory, QFlags<QUrl::UserInputResolutionOption> options)\nThis method is static and can be called without an instance.", &_init_f_fromUserInput_8122, &_call_f_fromUserInput_8122);
  methods += new qt_gsi::GenericStaticMethod (":idnWhitelist", "@brief Static method QStringList QUrl::idnWhitelist()\nThis method is static and can be called without an instance.", &_init_f_idnWhitelist_0, &_call_f_idnWhitelist_0);
  methods += new qt_gsi::GenericStaticMethod ("setIdnWhitelist|idnWhitelist=", "@brief Static method void QUrl::setIdnWhitelist(const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_setIdnWhitelist_2437, &_call_f_setIdnWhitelist_2437);
  methods += new qt_gsi::GenericStaticMethod ("toAce", "@brief Static method QByteArray QUrl::toAce(const QString &)\nThis method is static and can be called without an instance.", &_init_f_toAce_2025, &_call_f_toAce_2025);
  methods += new qt_gsi::GenericStaticMethod ("toPercentEncoding", "@brief Static method QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)\nThis method is static and can be called without an instance.", &_init_f_toPercentEncoding_6427, &_call_f_toPercentEncoding_6427);
  methods += new qt_gsi::GenericStaticMethod ("toStringList", "@brief Static method QStringList QUrl::toStringList(const QList<QUrl> &uris, QUrlTwoFlags<QUrl::UrlFormattingOption, QUrl::ComponentFormattingOption> options)\nThis method is static and can be called without an instance.", &_init_f_toStringList_9779, &_call_f_toStringList_9779);
  return methods;
}

gsi::Class<QUrl> decl_QUrl ("QtCore", "QUrl",
  methods_QUrl (),
  "@qt\n@brief Binding of QUrl");


GSI_QTCORE_PUBLIC gsi::Class<QUrl> &qtdecl_QUrl () { return decl_QUrl; }

}


//  Implementation of the enum wrapper class for QUrl::ComponentFormattingOption
namespace qt_gsi
{

static gsi::Enum<QUrl::ComponentFormattingOption> decl_QUrl_ComponentFormattingOption_Enum ("QtCore", "QUrl_ComponentFormattingOption",
    gsi::enum_const ("PrettyDecoded", QUrl::PrettyDecoded, "@brief Enum constant QUrl::PrettyDecoded") +
    gsi::enum_const ("EncodeSpaces", QUrl::EncodeSpaces, "@brief Enum constant QUrl::EncodeSpaces") +
    gsi::enum_const ("EncodeUnicode", QUrl::EncodeUnicode, "@brief Enum constant QUrl::EncodeUnicode") +
    gsi::enum_const ("EncodeDelimiters", QUrl::EncodeDelimiters, "@brief Enum constant QUrl::EncodeDelimiters") +
    gsi::enum_const ("EncodeReserved", QUrl::EncodeReserved, "@brief Enum constant QUrl::EncodeReserved") +
    gsi::enum_const ("DecodeReserved", QUrl::DecodeReserved, "@brief Enum constant QUrl::DecodeReserved") +
    gsi::enum_const ("FullyEncoded", QUrl::FullyEncoded, "@brief Enum constant QUrl::FullyEncoded") +
    gsi::enum_const ("FullyDecoded", QUrl::FullyDecoded, "@brief Enum constant QUrl::FullyDecoded"),
  "@qt\n@brief This class represents the QUrl::ComponentFormattingOption enum");

static gsi::QFlagsClass<QUrl::ComponentFormattingOption > decl_QUrl_ComponentFormattingOption_Enums ("QtCore", "QUrl_QFlags_ComponentFormattingOption",
  "@qt\n@brief This class represents the QFlags<QUrl::ComponentFormattingOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_ComponentFormattingOption_Enum_in_parent (decl_QUrl_ComponentFormattingOption_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_ComponentFormattingOption_Enum_as_child (decl_QUrl_ComponentFormattingOption_Enum, "ComponentFormattingOption");
static gsi::ClassExt<QUrl> decl_QUrl_ComponentFormattingOption_Enums_as_child (decl_QUrl_ComponentFormattingOption_Enums, "QFlags_ComponentFormattingOption");

}


//  Implementation of the enum wrapper class for QUrl::ParsingMode
namespace qt_gsi
{

static gsi::Enum<QUrl::ParsingMode> decl_QUrl_ParsingMode_Enum ("QtCore", "QUrl_ParsingMode",
    gsi::enum_const ("TolerantMode", QUrl::TolerantMode, "@brief Enum constant QUrl::TolerantMode") +
    gsi::enum_const ("StrictMode", QUrl::StrictMode, "@brief Enum constant QUrl::StrictMode") +
    gsi::enum_const ("DecodedMode", QUrl::DecodedMode, "@brief Enum constant QUrl::DecodedMode"),
  "@qt\n@brief This class represents the QUrl::ParsingMode enum");

static gsi::QFlagsClass<QUrl::ParsingMode > decl_QUrl_ParsingMode_Enums ("QtCore", "QUrl_QFlags_ParsingMode",
  "@qt\n@brief This class represents the QFlags<QUrl::ParsingMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_ParsingMode_Enum_in_parent (decl_QUrl_ParsingMode_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_ParsingMode_Enum_as_child (decl_QUrl_ParsingMode_Enum, "ParsingMode");
static gsi::ClassExt<QUrl> decl_QUrl_ParsingMode_Enums_as_child (decl_QUrl_ParsingMode_Enums, "QFlags_ParsingMode");

}


//  Implementation of the enum wrapper class for QUrl::UrlFormattingOption
namespace qt_gsi
{

static gsi::Enum<QUrl::UrlFormattingOption> decl_QUrl_UrlFormattingOption_Enum ("QtCore", "QUrl_UrlFormattingOption",
    gsi::enum_const ("None", QUrl::None, "@brief Enum constant QUrl::None") +
    gsi::enum_const ("RemoveScheme", QUrl::RemoveScheme, "@brief Enum constant QUrl::RemoveScheme") +
    gsi::enum_const ("RemovePassword", QUrl::RemovePassword, "@brief Enum constant QUrl::RemovePassword") +
    gsi::enum_const ("RemoveUserInfo", QUrl::RemoveUserInfo, "@brief Enum constant QUrl::RemoveUserInfo") +
    gsi::enum_const ("RemovePort", QUrl::RemovePort, "@brief Enum constant QUrl::RemovePort") +
    gsi::enum_const ("RemoveAuthority", QUrl::RemoveAuthority, "@brief Enum constant QUrl::RemoveAuthority") +
    gsi::enum_const ("RemovePath", QUrl::RemovePath, "@brief Enum constant QUrl::RemovePath") +
    gsi::enum_const ("RemoveQuery", QUrl::RemoveQuery, "@brief Enum constant QUrl::RemoveQuery") +
    gsi::enum_const ("RemoveFragment", QUrl::RemoveFragment, "@brief Enum constant QUrl::RemoveFragment") +
    gsi::enum_const ("PreferLocalFile", QUrl::PreferLocalFile, "@brief Enum constant QUrl::PreferLocalFile") +
    gsi::enum_const ("StripTrailingSlash", QUrl::StripTrailingSlash, "@brief Enum constant QUrl::StripTrailingSlash") +
    gsi::enum_const ("RemoveFilename", QUrl::RemoveFilename, "@brief Enum constant QUrl::RemoveFilename") +
    gsi::enum_const ("NormalizePathSegments", QUrl::NormalizePathSegments, "@brief Enum constant QUrl::NormalizePathSegments"),
  "@qt\n@brief This class represents the QUrl::UrlFormattingOption enum");

static gsi::QFlagsClass<QUrl::UrlFormattingOption > decl_QUrl_UrlFormattingOption_Enums ("QtCore", "QUrl_QFlags_UrlFormattingOption",
  "@qt\n@brief This class represents the QFlags<QUrl::UrlFormattingOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_UrlFormattingOption_Enum_in_parent (decl_QUrl_UrlFormattingOption_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_UrlFormattingOption_Enum_as_child (decl_QUrl_UrlFormattingOption_Enum, "UrlFormattingOption");
static gsi::ClassExt<QUrl> decl_QUrl_UrlFormattingOption_Enums_as_child (decl_QUrl_UrlFormattingOption_Enums, "QFlags_UrlFormattingOption");

}


//  Implementation of the enum wrapper class for QUrl::UserInputResolutionOption
namespace qt_gsi
{

static gsi::Enum<QUrl::UserInputResolutionOption> decl_QUrl_UserInputResolutionOption_Enum ("QtCore", "QUrl_UserInputResolutionOption",
    gsi::enum_const ("DefaultResolution", QUrl::DefaultResolution, "@brief Enum constant QUrl::DefaultResolution") +
    gsi::enum_const ("AssumeLocalFile", QUrl::AssumeLocalFile, "@brief Enum constant QUrl::AssumeLocalFile"),
  "@qt\n@brief This class represents the QUrl::UserInputResolutionOption enum");

static gsi::QFlagsClass<QUrl::UserInputResolutionOption > decl_QUrl_UserInputResolutionOption_Enums ("QtCore", "QUrl_QFlags_UserInputResolutionOption",
  "@qt\n@brief This class represents the QFlags<QUrl::UserInputResolutionOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_UserInputResolutionOption_Enum_in_parent (decl_QUrl_UserInputResolutionOption_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_UserInputResolutionOption_Enum_as_child (decl_QUrl_UserInputResolutionOption_Enum, "UserInputResolutionOption");
static gsi::ClassExt<QUrl> decl_QUrl_UserInputResolutionOption_Enums_as_child (decl_QUrl_UserInputResolutionOption_Enums, "QFlags_UserInputResolutionOption");

}

