/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/symbol.h"
#include "include/piece.h"

class LWSymbolBreakLine : public LWSymbol {

const gchar *getName ()
{
	return "linebreak";
}	

gchar *getHint ()
{
	return _("Break the line");
}

gboolean canClone ()
{
	return FALSE;	
}

void onDndCopy (LWPiece *sourcepiece, LWPiece *destpiece)
{
	g_return_if_fail (sourcepiece != NULL);
	g_return_if_fail (destpiece != NULL);
	g_return_if_fail (sourcepiece->getSymbol() == this);
	g_return_if_fail (LW_TYPE_PROGRAM == destpiece->getRow()->getBoard()->getType());

	destpiece->getRow()->splitBefore (destpiece);
}

void onDndMove (LWPiece *sourcepiece, LWPiece *destpiece)
{
	(void) sourcepiece;
	(void) destpiece;
	
	g_assert_not_reached ();
}

};

LWSymbol *new_LWSymbolBreakLine()
{
	return new LWSymbolBreakLine();
}
