; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i8 @scmp_1(i32 %x, i32 %y) {
; CHECK-LABEL: @scmp_1(
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 1
; CHECK:       false:
; CHECK-NEXT:    ret i8 20
;
  %cond = icmp sgt i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  %r = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %r
false:
  ret i8 20
}

define i8 @ucmp_1(i32 %x, i32 %y) {
; CHECK-LABEL: @ucmp_1(
; CHECK-NEXT:    [[COND:%.*]] = icmp ult i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 -1
; CHECK:       false:
; CHECK-NEXT:    ret i8 20
;
  %cond = icmp ult i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  %r = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %r
false:
  ret i8 20
}

define i8 @scmp_2(i32 %x, i32 %y) {
; CHECK-LABEL: @scmp_2(
; CHECK-NEXT:    [[COND:%.*]] = icmp sge i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 20
; CHECK:       false:
; CHECK-NEXT:    ret i8 -1
;
  %cond = icmp sge i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  ret i8 20
false:
  %r = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %r
}

define i8 @ucmp_2(i32 %x, i32 %y) {
; CHECK-LABEL: @ucmp_2(
; CHECK-NEXT:    [[COND:%.*]] = icmp ule i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 20
; CHECK:       false:
; CHECK-NEXT:    ret i8 1
;
  %cond = icmp ule i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  ret i8 20
false:
  %r = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %r
}

define i8 @scmp_3(i32 %x, i32 %y) {
; CHECK-LABEL: @scmp_3(
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 0
; CHECK:       false:
; CHECK-NEXT:    ret i8 20
;
  %cond = icmp eq i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  %r = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %r
false:
  ret i8 20
}

define i8 @ucmp_3(i32 %x, i32 %y) {
; CHECK-LABEL: @ucmp_3(
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 0
; CHECK:       false:
; CHECK-NEXT:    ret i8 20
;
  %cond = icmp eq i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  %r = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %r
false:
  ret i8 20
}

; Negative test: signedness mismatch
define i8 @scmp_4(i32 %x, i32 %y) {
; CHECK-LABEL: @scmp_4(
; CHECK-NEXT:    [[COND:%.*]] = icmp ugt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 20
; CHECK:       false:
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.scmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %cond = icmp ugt i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  ret i8 20
false:
  %r = call i8 @llvm.scmp(i32 %x, i32 %y)
  ret i8 %r
}

define i8 @ucmp_4(i32 %x, i32 %y) {
; CHECK-LABEL: @ucmp_4(
; CHECK-NEXT:    [[COND:%.*]] = icmp slt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i8 20
; CHECK:       false:
; CHECK-NEXT:    [[R:%.*]] = call i8 @llvm.ucmp.i8.i32(i32 [[X]], i32 [[Y]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %cond = icmp slt i32 %x, %y
  br i1 %cond, label %true, label %false
true:
  ret i8 20
false:
  %r = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %r
}
