To download and unpack the latest version of libntruprime:

    wget -m https://libntruprime.cr.yp.to/libntruprime-latest-version.txt
    version=$(cat libntruprime.cr.yp.to/libntruprime-latest-version.txt)
    wget -m https://libntruprime.cr.yp.to/libntruprime-$version.tar.gz
    tar -xzf libntruprime.cr.yp.to/libntruprime-$version.tar.gz
    cd libntruprime-$version

Then [install](install.html)
and [test](test.html).

### Archives and changelog (reverse chronological) {#changelog}

[`libntruprime-20241021.tar.gz`](libntruprime-20241021.tar.gz) [browse](libntruprime-20241021.html)

Port the `encode` test to big-endian platforms.
Thanks to Jan Mojzis for pointing out s390x test failures.

Revamp `checkinsns` to use `python3-capstone`
(or to skip instruction-set tests if that isn't installed).

For `checknamespace`,
support `__sparc.get_pc_thunk` for Solaris,
and support class `D` for PPC.

[`libntruprime-20241008.tar.gz`](libntruprime-20241008.tar.gz) [browse](libntruprime-20241008.html)

Upgrade to `cryptoint 20241003`.

Say `full tests succeeded` in `ntruprime-fulltest` documentation.

In `autogen/test`, clarify code, and allow saving from a blank slate.

[`libntruprime-20240910.tar.gz`](libntruprime-20240910.tar.gz) [browse](libntruprime-20240910.html)

Return `void` for `keypair`, `enc`, `dec`.
Thanks to Jan Mojzis for pointing out the discrepancy between code and documentation.

Fix missing installation of command-line tools.
Thanks to Simon Josefsson for pointing out the issue.

[`libntruprime-20240825.tar.gz`](libntruprime-20240825.tar.gz) [browse](libntruprime-20240825.html)

First release.
