---
title: Vasp's POSCAR format
---

@Note [Reference](https://www.vasp.at/wiki/index.php/POSCAR)

The format is identified by the extension ``vasp``, ``poscar`` or ``contcar``.
Alternatively, the basenames ``poscar`` and ``contcar`` identify the format as well.

## Examples

Ammonia molecular crystal in pre Vasp 5 POSCAR format:

```text
 H  N 
 1.0000000000000000
     5.0133599999999996    0.0000000000000000    0.0000000000000000
     0.0000000000000000    5.0133599999999996    0.0000000000000000
     0.0000000000000000    0.0000000000000000    5.0133599999999996
  12   4
Cartesian
  2.1985588943999996  1.7639005823999998  0.8801454815999999
  1.7639005823999998  0.8801454815999999  2.1985588943999996
  0.8801454815999999  2.1985588943999996  1.7639005823999998
  4.8411510839999998  1.6194155471999998  4.9398140088000000
  4.3563090384000001  2.4998116967999997  3.6324801215999996
  3.5195792543999995  1.1535741359999998  4.0840334567999994
  4.0840334567999994  3.5195792543999995  1.1535741359999998
  4.9398140088000000  4.8411510839999998  1.6194155471999998
  3.6324801215999996  4.3563090384000001  2.4998116967999997
  2.4998116967999997  3.6324801215999996  4.3563090384000001
  1.1535741359999998  4.0840334567999994  3.5195792543999995
  1.6194155471999998  4.9398140088000000  4.8411510839999998
  1.3746131783999997  1.3746131783999997  1.3746131783999997
  3.9981545999999994  1.9910559239999999  4.4636450759999997
  4.4636450759999997  3.9981545999999994  1.9910559239999999
  1.9910559239999999  4.4636450759999997  3.9981545999999994
```

Carbondioxide in POSCAR format:

```text
4CO2
    1.00000000000000
    5.68032000000000    0.00000000000000    0.00000000000000
    0.00000000000000    5.68032000000000    0.00000000000000
    0.00000000000000    0.00000000000000    5.68032000000000
 C    O   
 4 8
Cartesian
    0.94412598720000    0.94378516800000    0.95435056320000
    3.71799665280000    0.95565703680000    3.73168622400000
    3.71595173760000    3.71492928000000    0.96923300160000
    0.95298728640000    3.72208648320000    3.72969811200000
    1.62139054080000    1.61906160960000    1.63138790400000
    0.26566856640000    0.26941757760000    0.27765404160000
    4.39145539200000    1.63462568640000    3.05459208000000
    3.04408348800000    0.27646117440000    4.40804192640000
    4.39105776960000    3.04164095040000    0.28810583040000
    3.03999365760000    4.38793359360000    1.64973533760000
    0.27413224320000    4.40037349440000    3.05737543680000
    1.63121749440000    3.04345865280000    4.40230480320000
```

## Extensions

No extension implemented to the original format.

## Missing Features

The implementation of this format is (to our knowledge) feature-complete.

@Note Feel free to bring missing features to our attention by opening an issue.
