/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from server-decoration.xml
 * To regenerate, run the “refresh-wayland-wrapper” target.
 */

#include "server-decoration_wrapper.h"

#include <boost/throw_exception.hpp>
#include <boost/exception/diagnostic_information.hpp>

#include <wayland-server-core.h>

#include "mir/log.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const org_kde_kwin_server_decoration_interface_data;
extern struct wl_interface const org_kde_kwin_server_decoration_manager_interface_data;
extern struct wl_interface const wl_surface_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// ServerDecorationManager

mw::ServerDecorationManager* mw::ServerDecorationManager::from(struct wl_resource* resource)
{
    return static_cast<ServerDecorationManager*>(wl_resource_get_user_data(resource));
}

struct mw::ServerDecorationManager::Thunks
{
    static int const supported_version;

    static void create_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface)
    {
        auto me = static_cast<ServerDecorationManager*>(wl_resource_get_user_data(resource));
        wl_resource* id_resolved{
            wl_resource_create(client, &org_kde_kwin_server_decoration_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->create(id_resolved, surface);
        }
        catch(...)
        {
            internal_error_processing_request(client, "ServerDecorationManager::create()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ServerDecorationManager*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<ServerDecorationManager::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &org_kde_kwin_server_decoration_manager_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "ServerDecorationManager global bind");
        }
    }

    static struct wl_interface const* create_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::ServerDecorationManager::Thunks::supported_version = 1;

mw::ServerDecorationManager::ServerDecorationManager(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mw::ServerDecorationManager::send_default_mode_event(uint32_t mode) const
{
    wl_resource_post_event(resource, Opcode::default_mode, mode);
}

bool mw::ServerDecorationManager::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_manager_interface_data, Thunks::request_vtable);
}

void mw::ServerDecorationManager::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

mw::ServerDecorationManager::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &org_kde_kwin_server_decoration_manager_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{}

auto mw::ServerDecorationManager::Global::interface_name() const -> char const*
{
    return ServerDecorationManager::interface_name;
}

struct wl_interface const* mw::ServerDecorationManager::Thunks::create_types[] {
    &org_kde_kwin_server_decoration_interface_data,
    &wl_surface_interface_data};

struct wl_message const mw::ServerDecorationManager::Thunks::request_messages[] {
    {"create", "no", create_types}};

struct wl_message const mw::ServerDecorationManager::Thunks::event_messages[] {
    {"default_mode", "u", all_null_types}};

void const* mw::ServerDecorationManager::Thunks::request_vtable[] {
    (void*)Thunks::create_thunk};

// ServerDecoration

mw::ServerDecoration* mw::ServerDecoration::from(struct wl_resource* resource)
{
    return static_cast<ServerDecoration*>(wl_resource_get_user_data(resource));
}

struct mw::ServerDecoration::Thunks
{
    static int const supported_version;

    static void release_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        auto me = static_cast<ServerDecoration*>(wl_resource_get_user_data(resource));
        try
        {
            me->release();
        }
        catch(...)
        {
            internal_error_processing_request(client, "ServerDecoration::release()");
        }
    }

    static void request_mode_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t mode)
    {
        auto me = static_cast<ServerDecoration*>(wl_resource_get_user_data(resource));
        try
        {
            me->request_mode(mode);
        }
        catch(...)
        {
            internal_error_processing_request(client, "ServerDecoration::request_mode()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<ServerDecoration*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::ServerDecoration::Thunks::supported_version = 1;

mw::ServerDecoration::ServerDecoration(struct wl_resource* resource, Version<1>)
    : client{wl_resource_get_client(resource)},
      resource{resource}
{
    if (resource == nullptr)
    {
        BOOST_THROW_EXCEPTION((std::bad_alloc{}));
    }
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

void mw::ServerDecoration::send_mode_event(uint32_t mode) const
{
    wl_resource_post_event(resource, Opcode::mode, mode);
}

bool mw::ServerDecoration::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_interface_data, Thunks::request_vtable);
}

void mw::ServerDecoration::destroy_wayland_object() const
{
    wl_resource_destroy(resource);
}

struct wl_message const mw::ServerDecoration::Thunks::request_messages[] {
    {"release", "", all_null_types},
    {"request_mode", "u", all_null_types}};

struct wl_message const mw::ServerDecoration::Thunks::event_messages[] {
    {"mode", "u", all_null_types}};

void const* mw::ServerDecoration::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk,
    (void*)Thunks::request_mode_thunk};

namespace mir
{
namespace wayland
{

struct wl_interface const org_kde_kwin_server_decoration_manager_interface_data {
    mw::ServerDecorationManager::interface_name,
    mw::ServerDecorationManager::Thunks::supported_version,
    1, mw::ServerDecorationManager::Thunks::request_messages,
    1, mw::ServerDecorationManager::Thunks::event_messages};

struct wl_interface const org_kde_kwin_server_decoration_interface_data {
    mw::ServerDecoration::interface_name,
    mw::ServerDecoration::Thunks::supported_version,
    2, mw::ServerDecoration::Thunks::request_messages,
    1, mw::ServerDecoration::Thunks::event_messages};

}
}
