# Interface: DocumentType

### Properties

* [data](#data)
* [name](#name)
* [next](#next)
* [nextSibling](#nextsibling)
* [nodeType](#nodetype)
* [parent](#parent)
* [parentNode](#parentnode)
* [prev](#prev)
* [previousSibling](#previoussibling)
* [type](#type)
* [x-name](#x_name)
* [x-publicId](#x_publicid)
* [x-systemId](#x_systemid)

---

## Properties

<a id="data"></a>

###  data

**● data**: *`string`*

Serialized doctype [name](#name), {@link publicId} and {@link systemId}.

___
<a id="name"></a>

###  name

**● name**: *"!doctype"*

Node name.

___
<a id="next"></a>

###  next

**● next**: *Node*

Next sibling.

___
<a id="nextsibling"></a>

###  nextSibling

**● nextSibling**: *Node*

Same as [next](#next). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="nodetype"></a>

###  nodeType

**● nodeType**: *`number`*

[DOM spec](https://dom.spec.whatwg.org/#dom-node-nodetype)-compatible node [type](#type).

___
<a id="parent"></a>

###  parent

**● parent**: *Node*

Parent node.

___
<a id="parentnode"></a>

###  parentNode

**● parentNode**: *Node*

Same as [parent](#parent). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="prev"></a>

###  prev

**● prev**: *Node*

Previous sibling.

___
<a id="previoussibling"></a>

###  previousSibling

**● previousSibling**: *Node*

Same as [prev](#prev). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="type"></a>

###  type

**● type**: *"directive"*

The type of the node.

___
<a id="x_name"></a>

###  x-name

**● x-name**: *`string`*

Document type name.

___
<a id="x_publicid"></a>

###  x-publicId

**● x-publicId**: *`string`*

Document type public identifier.

___
<a id="x_systemid"></a>

###  x-systemId

**● x-systemId**: *`string`*

Document type system identifier.

___

