/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.basicsearch;

import com.sourceforge.knecs.dsm.basicsearch.FromClause;
import com.sourceforge.knecs.dsm.basicsearch.InvalidBasicQueryException;
import com.sourceforge.knecs.dsm.basicsearch.OrderByClause;
import com.sourceforge.knecs.dsm.basicsearch.SelectClause;
import com.sourceforge.knecs.dsm.basicsearch.UnsupportedExpressionException;
import com.sourceforge.knecs.dsm.basicsearch.WhereClause;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class BasicSearchQuery {
    public static final String INVALID_SELECT_CLAUSE = "Selct clause missing, either the allprop must be true or at least one property needs to be added to the selected properties list";
    public static final String INVALID_FROM_CLAUSE = "From clause is missing, at least one query scope needs to be added";
    public static final Namespace DAV_NS = Namespace.getNamespace("d", "DAV:");
    public static final Namespace XS_NS = Namespace.getNamespace("xs", "http://www.w3.org/2001/XMLSchema");
    public static final Namespace XSI_NS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace SLIDE_NS = Namespace.getNamespace("s", "http://jakarta.apache.org/slide/");
    public static final String SEARCHREQUEST = "searchrequest";
    public static final String BASICSEARCH = "basicsearch";
    public static final String SELECT = "select";
    public static final String ALL_PROP = "allprop";
    public static final String PROP = "prop";
    public static final String FROM = "from";
    public static final String SCOPE = "scope";
    public static final String HREF = "href";
    public static final String DEPTH = "depth";
    public static final String DEPTH_0 = "0";
    public static final String DEPTH_1 = "1";
    public static final String DEPTH_INFINITY = "INFINITE";
    public static final String INCLUDE_VERSIONS = "include-versions";
    public static final String WHERE = "where";
    public static final String LITERAL = "literal";
    public static final String TYPED_LITERAL = "typed-literal";
    public static final String EQ = "eq";
    public static final String LTE = "lte";
    public static final String LT = "lt";
    public static final String GTE = "gte";
    public static final String GT = "gt";
    public static final String LIKE = "like";
    public static final String IS_DEFINED = "is-defined";
    public static final String PROP_CONTAINS = "propcontains";
    public static final String BETWEEN = "between";
    public static final String ALL_INDEXED_PROP = "allindexedprop";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String NOT = "not";
    public static final String IS_COLLECTION = "is-collection";
    public static final String CONTAINS = "contains";
    public static final String ORDER_BY = "orderby";
    public static final String ORDER = "order";
    public static final String ASCENDING = "ascending";
    public static final String DESCENDING = "descending";
    public static final String LIMIT = "limit";
    public static final String N_RESULTS = "nresults";
    public static final String CASELESS = "caseless";
    public static final String TYPE = "type";
    public static final String XS_STRING = "xs:string";
    public static final String XS_INTEGER = "xs:integer";
    public static final String XS_DATETIME = "xs:dateTime";
    public static final String XS_FLOAT = "xs:float";
    SelectClause mSelectClause = new SelectClause();
    FromClause mFromClause = new FromClause();
    WhereClause mWhereClause = new WhereClause();
    OrderByClause mOrderByClause = new OrderByClause();
    int mLimit = 0;

    public SelectClause getSelectClause() {
        return this.mSelectClause;
    }

    public FromClause getFromClause() {
        return this.mFromClause;
    }

    public WhereClause getWhereClause() {
        return this.mWhereClause;
    }

    public OrderByClause getOrderByClause() {
        return this.mOrderByClause;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public void setSelectClause(SelectClause clause) {
        this.mSelectClause = clause;
    }

    public void setFromClause(FromClause clause) {
        this.mFromClause = clause;
    }

    public void setWhereClause(WhereClause clause) {
        this.mWhereClause = clause;
    }

    public void setOrderByClause(OrderByClause clause) {
        this.mOrderByClause = clause;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public String getQuery() throws InvalidBasicQueryException, UnsupportedExpressionException {
        String ret = "";
        try {
            if (this.mSelectClause.empty() && !this.mSelectClause.isAllProp()) {
                throw new InvalidBasicQueryException(INVALID_SELECT_CLAUSE);
            }
            if (this.mFromClause.empty()) {
                throw new InvalidBasicQueryException(INVALID_FROM_CLAUSE);
            }
            Element searchRequest = new Element(SEARCHREQUEST, DAV_NS);
            Document doc = new Document(searchRequest);
            Element basicSearch = new Element(BASICSEARCH, DAV_NS);
            searchRequest.addContent(basicSearch);
            basicSearch.addContent(this.mSelectClause.getElement());
            basicSearch.addContent(this.mFromClause.getElement());
            if (!this.mWhereClause.empty()) {
                basicSearch.addContent(this.mWhereClause.getElement());
            }
            if (!this.mOrderByClause.empty()) {
                basicSearch.addContent(this.mOrderByClause.getElement());
            }
            if (this.mLimit > 0) {
                Element limitElement = new Element(LIMIT, DAV_NS);
                Element nresultsElement = new Element(N_RESULTS, DAV_NS);
                nresultsElement.setText(String.valueOf(this.mLimit));
                limitElement.addContent(nresultsElement);
                basicSearch.addContent(limitElement);
            }
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            ret = outputter.outputString(doc);
        }
        catch (InvalidBasicQueryException e) {
            throw e;
        }
        catch (UnsupportedExpressionException e) {
            throw e;
        }
        return ret;
    }
}

