/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComponentRoseQueue
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseQueue(Style style, Style stereo, SymbolContext biColor, FontConfiguration font, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer, UFont fontForStereotype, HColor htmlColorForStereotype) {
        super(style, stereo, LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 3, 3, 0, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
        if (UseStyle.useBetaStyle()) {
            biColor = style.getSymbolContext(spriteContainer.getThemeStyle(), this.getIHtmlColorSet());
        }
        this.head = head;
        this.stickman = USymbol.QUEUE.asSmall(TextBlockUtils.empty(0.0, 0.0), this.getTextBlock(), TextBlockUtils.empty(0.0, 0.0), biColor, HorizontalAlignment.CENTER);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        ug = ug.apply(UTranslate.dx(delta));
        this.stickman.drawU(ug);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getWidth();
    }
}

