/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Tag
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 3326379903447135320L;
    protected int m_ID;
    protected String m_IDStr;
    protected String m_Readable;

    public Tag() {
        this(0, "A new tag", "A new tag", true);
    }

    public Tag(int ident, String readable) {
        this(ident, "", readable);
    }

    public Tag(int ident, String identStr, String readable) {
        this(ident, identStr, readable, true);
    }

    public Tag(int ident, String identStr, String readable, boolean upperCase) {
        this.m_ID = ident;
        if (identStr.length() == 0) {
            this.m_IDStr = "" + ident;
        } else {
            this.m_IDStr = identStr;
            if (upperCase) {
                this.m_IDStr = identStr.toUpperCase();
            }
        }
        this.m_Readable = readable;
    }

    public int getID() {
        return this.m_ID;
    }

    public void setID(int id) {
        this.m_ID = id;
    }

    public String getIDStr() {
        return this.m_IDStr;
    }

    public void setIDStr(String str) {
        this.m_IDStr = str;
    }

    public String getReadable() {
        return this.m_Readable;
    }

    public void setReadable(String r) {
        this.m_Readable = r;
    }

    public String toString() {
        return this.m_IDStr;
    }

    public static String toOptionList(Tag[] tags) {
        String result = "<";
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                result = result + "|";
            }
            result = result + tags[i];
        }
        result = result + ">";
        return result;
    }

    public static String toOptionSynopsis(Tag[] tags) {
        String result = "";
        for (int i = 0; i < tags.length; ++i) {
            result = result + "\t\t" + tags[i].getIDStr() + " = " + tags[i].getReadable() + "\n";
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.13 $");
    }
}

