# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`vector`](#vector): Vector module for Puppet
* [`vector::configure`](#vector--configure): Creates configuraton files, and creates systemd files if configured to do so
* [`vector::install`](#vector--install): Installs vector, if configured to do so
* [`vector::service`](#vector--service): Manages the systemd service for vector
* [`vector::setup`](#vector--setup): sets up some directories for configurations to go into
* [`vector::user`](#vector--user): Private class that manages the user and group vector runs as

### Defined types

* [`vector::configfile`](#vector--configfile): A type to create a vector config file, composing of sources, transforms, and sinks
* [`vector::sink`](#vector--sink): Creates a vector sink
* [`vector::source`](#vector--source): Creates a Vector source
* [`vector::systemd_dropin`](#vector--systemd_dropin): A systemd dropin file for Vector
* [`vector::transform`](#vector--transform): Creates a Vector transform

### Functions

* [`vector::dump_config`](#vector--dump_config): vector::dump_config

### Data types

* [`Vector::Enabled`](#Vector--Enabled): defines a valid value for the 'enabled' parameter for the vector systemd service
* [`Vector::Ensure`](#Vector--Ensure): defines a valid value for the vector systemd service 'ensure' parameter
* [`Vector::ValidConfigFormat`](#Vector--ValidConfigFormat): defines the valid configuration file extensions for vector

## Classes

### <a name="vector"></a>`vector`

vector

Installs, configures, then runs the Vector log and metric tool on RedHat and Debian type systems
Note - this does not manage the repositories, it is assumed they are already configured

#### Examples

##### 

```puppet
include vector
```

##### 

```puppet
class vector {
  data_dir => '/data/vector',
  install_vector => false,
}
```

#### Parameters

The following parameters are available in the `vector` class:

* [`version`](#-vector--version)
* [`install_vector`](#-vector--install_vector)
* [`config_dir`](#-vector--config_dir)
* [`config_dir_mode`](#-vector--config_dir_mode)
* [`data_dir`](#-vector--data_dir)
* [`data_dir_mode`](#-vector--data_dir_mode)
* [`user`](#-vector--user)
* [`group`](#-vector--group)
* [`manage_user`](#-vector--manage_user)
* [`user_opts`](#-vector--user_opts)
* [`manage_group`](#-vector--manage_group)
* [`group_opts`](#-vector--group_opts)
* [`service_name`](#-vector--service_name)
* [`manage_systemd`](#-vector--manage_systemd)
* [`vector_executable`](#-vector--vector_executable)
* [`service_ensure`](#-vector--service_ensure)
* [`service_enabled`](#-vector--service_enabled)
* [`service_restart`](#-vector--service_restart)
* [`environment_file`](#-vector--environment_file)
* [`global_options`](#-vector--global_options)
* [`environment_vars`](#-vector--environment_vars)
* [`config_files`](#-vector--config_files)
* [`sources`](#-vector--sources)
* [`transforms`](#-vector--transforms)
* [`sinks`](#-vector--sinks)
* [`systemd_dropins`](#-vector--systemd_dropins)
* [`notify_on_config_change`](#-vector--notify_on_config_change)

##### <a name="-vector--version"></a>`version`

Data type: `Optional[String]`

What version of Vector to install. If left undef, will use default from repositories

##### <a name="-vector--install_vector"></a>`install_vector`

Data type: `Boolean`

Whether to have this module install Vector. Using this means the version param is ignored

##### <a name="-vector--config_dir"></a>`config_dir`

Data type: `String`

Base directory for configuration, default /etc/vector

##### <a name="-vector--config_dir_mode"></a>`config_dir_mode`

Data type: `String`

File mode for the configuration directory, default 0755

##### <a name="-vector--data_dir"></a>`data_dir`

Data type: `String`

Directory for vector to store buffer and state data

##### <a name="-vector--data_dir_mode"></a>`data_dir_mode`

Data type: `String`

File mode for the data directory, default 0755

##### <a name="-vector--user"></a>`user`

Data type: `String`

What user to run Vector as, default 'vector'

##### <a name="-vector--group"></a>`group`

Data type: `String`

What group to run Vector as, default 'vector'

##### <a name="-vector--manage_user"></a>`manage_user`

Data type: `Boolean`

Boolean to determine if puppet should manage the user vector runs as

##### <a name="-vector--user_opts"></a>`user_opts`

Data type: `Hash`

Dictionary of options to pass into the user resource, other than 'name' (specified with vector::user) and 'ensure'

##### <a name="-vector--manage_group"></a>`manage_group`

Data type: `Boolean`

Boolean to determine if puppet should manage the group vector runs as

##### <a name="-vector--group_opts"></a>`group_opts`

Data type: `Hash`

Dictionary of options to pass into the group resource, other than 'name' (specified with vector::group) and 'ensure'

##### <a name="-vector--service_name"></a>`service_name`

Data type: `String`

Name of the service, default 'vector'

##### <a name="-vector--manage_systemd"></a>`manage_systemd`

Data type: `Boolean`

Whether this module should manage the systemd unit file, default true

##### <a name="-vector--vector_executable"></a>`vector_executable`

Data type: `String`

Path to vector executable file

##### <a name="-vector--service_ensure"></a>`service_ensure`

Data type: `Vector::Ensure`

Used in the 'service' resource for vector, default true

##### <a name="-vector--service_enabled"></a>`service_enabled`

Data type: `Vector::Enabled`

Used in the 'service' resource for vector, default true

##### <a name="-vector--service_restart"></a>`service_restart`

Data type: `String`

Used in the generated systemd unit file, default always

Default value: `'always'`

##### <a name="-vector--environment_file"></a>`environment_file`

Data type: `String`

Location of the environment file for Vector

##### <a name="-vector--global_options"></a>`global_options`

Data type: `Hash`

Hash of global options for vector, besides data_dir (specifying data_dir here will be ignored)

Default value: `{}`

##### <a name="-vector--environment_vars"></a>`environment_vars`

Data type: `Hash`

Hash of environment variables to make available to vector

Default value: `{}`

##### <a name="-vector--config_files"></a>`config_files`

Data type: `Hash`

Hash of vector::configfile instances to create

Default value: `{}`

##### <a name="-vector--sources"></a>`sources`

Data type: `Hash`

Hash of vector::source instances to create

Default value: `{}`

##### <a name="-vector--transforms"></a>`transforms`

Data type: `Hash`

Hash of vector::transform instances to create

Default value: `{}`

##### <a name="-vector--sinks"></a>`sinks`

Data type: `Hash`

Hash of vector::sink instances to create

Default value: `{}`

##### <a name="-vector--systemd_dropins"></a>`systemd_dropins`

Data type: `Hash`

Hash of vector::systemd_dropin instances to create

Default value: `{}`

##### <a name="-vector--notify_on_config_change"></a>`notify_on_config_change`

Data type: `Boolean`



### <a name="vector--configure"></a>`vector::configure`

vector::configure

### <a name="vector--install"></a>`vector::install`

vector::summary

### <a name="vector--service"></a>`vector::service`

vector::service

### <a name="vector--setup"></a>`vector::setup`

vector::setup

### <a name="vector--user"></a>`vector::user`

vector::user

## Defined types

### <a name="vector--configfile"></a>`vector::configfile`

vector::configfile

#### Parameters

The following parameters are available in the `vector::configfile` defined type:

* [`format`](#-vector--configfile--format)
* [`content`](#-vector--configfile--content)
* [`data`](#-vector--configfile--data)

##### <a name="-vector--configfile--format"></a>`format`

Data type: `Optional[Vector::ValidConfigFormat]`

File format, either yaml, yml, json, toml.

Default value: `undef`

##### <a name="-vector--configfile--content"></a>`content`

Data type: `Optional[String]`

File content, if specified, format must be specified and this string will be saved directly to disk

Default value: `undef`

##### <a name="-vector--configfile--data"></a>`data`

Data type: `Optional[Hash]`

Hash to be converted to specified format (or toml if format is not specified)

Default value: `undef`

### <a name="vector--sink"></a>`vector::sink`

vector::sink

#### Parameters

The following parameters are available in the `vector::sink` defined type:

* [`type`](#-vector--sink--type)
* [`inputs`](#-vector--sink--inputs)
* [`parameters`](#-vector--sink--parameters)
* [`format`](#-vector--sink--format)

##### <a name="-vector--sink--type"></a>`type`

Data type: `String`

Sink type. Consult vector documentation for available types

##### <a name="-vector--sink--inputs"></a>`inputs`

Data type: `Array[String]`

Array of inputs (sources or transforms)

##### <a name="-vector--sink--parameters"></a>`parameters`

Data type: `Hash`

Hash of additional parameters for the sink (besides type and inputs)

##### <a name="-vector--sink--format"></a>`format`

Data type: `Vector::ValidConfigFormat`

File format to save as, default toml

Default value: `'toml'`

### <a name="vector--source"></a>`vector::source`

vector::source

#### Parameters

The following parameters are available in the `vector::source` defined type:

* [`type`](#-vector--source--type)
* [`parameters`](#-vector--source--parameters)
* [`format`](#-vector--source--format)

##### <a name="-vector--source--type"></a>`type`

Data type: `String`

Source type. Consult vector documentation for available types.

##### <a name="-vector--source--parameters"></a>`parameters`

Data type: `Hash`

Hash of additional parameters for this source (besides type)

##### <a name="-vector--source--format"></a>`format`

Data type: `Vector::ValidConfigFormat`

File format to save as, default toml

Default value: `'toml'`

### <a name="vector--systemd_dropin"></a>`vector::systemd_dropin`

This defined type allows you to define any artibrary systemd dropin for vector
User can use either a file source or supply the content directly

#### Examples

##### 

```puppet
vector::systemd_dropin { '10-resource-limits': source => 'puppet:///deployment/vector/resource-limits.conf' }
```

#### Parameters

The following parameters are available in the `vector::systemd_dropin` defined type:

* [`source`](#-vector--systemd_dropin--source)
* [`content`](#-vector--systemd_dropin--content)

##### <a name="-vector--systemd_dropin--source"></a>`source`

Data type: `Optional[String]`

File source for this dropin config

Default value: `undef`

##### <a name="-vector--systemd_dropin--content"></a>`content`

Data type: `Optional[String]`

File content of this dropin config

Default value: `undef`

### <a name="vector--transform"></a>`vector::transform`

vector::transform

#### Parameters

The following parameters are available in the `vector::transform` defined type:

* [`type`](#-vector--transform--type)
* [`inputs`](#-vector--transform--inputs)
* [`parameters`](#-vector--transform--parameters)
* [`format`](#-vector--transform--format)

##### <a name="-vector--transform--type"></a>`type`

Data type: `String`

Transform type. Consult vector documentation for available types.

##### <a name="-vector--transform--inputs"></a>`inputs`

Data type: `Array[String]`

Array of inputs (source or transform)

##### <a name="-vector--transform--parameters"></a>`parameters`

Data type: `Hash`

Hash of additional parameters for this source (besides type and inputs)

##### <a name="-vector--transform--format"></a>`format`

Data type: `Vector::ValidConfigFormat`

File format to save as, default toml

Default value: `'toml'`

## Functions

### <a name="vector--dump_config"></a>`vector::dump_config`

Type: Puppet Language

vector::dump_config

#### `vector::dump_config(Hash $data, Vector::ValidConfigFormat $format = 'toml')`

vector::dump_config

Returns: `String` A String representing the dumped configuration

##### `data`

Data type: `Hash`

A puppet hash representing the configuration of some vector entity (source, transform, sink, etc)

##### `format`

Data type: `Vector::ValidConfigFormat`

What format to dump the $data parameter as (json, toml, yaml, yml)

## Data types

### <a name="Vector--Enabled"></a>`Vector::Enabled`

defines a valid value for the 'enabled' parameter for the vector systemd service

Alias of `Variant[Enum['manual','mask','delayed'], Boolean]`

### <a name="Vector--Ensure"></a>`Vector::Ensure`

defines a valid value for the vector systemd service 'ensure' parameter

Alias of `Variant[Enum['running','stopped'], Boolean]`

### <a name="Vector--ValidConfigFormat"></a>`Vector::ValidConfigFormat`

defines the valid configuration file extensions for vector

Alias of `Enum['json', 'yaml', 'yml', 'toml']`

