# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccumulatedType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Show costs accumulated over time."""

    TRUE = "true"
    FALSE = "false"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AlertCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Alert category."""

    COST = "Cost"
    USAGE = "Usage"
    BILLING = "Billing"
    SYSTEM = "System"


class AlertCriteria(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Criteria that triggered alert."""

    COST_THRESHOLD_EXCEEDED = "CostThresholdExceeded"
    USAGE_THRESHOLD_EXCEEDED = "UsageThresholdExceeded"
    CREDIT_THRESHOLD_APPROACHING = "CreditThresholdApproaching"
    CREDIT_THRESHOLD_REACHED = "CreditThresholdReached"
    QUOTA_THRESHOLD_APPROACHING = "QuotaThresholdApproaching"
    QUOTA_THRESHOLD_REACHED = "QuotaThresholdReached"
    MULTI_CURRENCY = "MultiCurrency"
    FORECAST_COST_THRESHOLD_EXCEEDED = "ForecastCostThresholdExceeded"
    FORECAST_USAGE_THRESHOLD_EXCEEDED = "ForecastUsageThresholdExceeded"
    INVOICE_DUE_DATE_APPROACHING = "InvoiceDueDateApproaching"
    INVOICE_DUE_DATE_REACHED = "InvoiceDueDateReached"
    CROSS_CLOUD_NEW_DATA_AVAILABLE = "CrossCloudNewDataAvailable"
    CROSS_CLOUD_COLLECTION_ERROR = "CrossCloudCollectionError"
    GENERAL_THRESHOLD_ERROR = "GeneralThresholdError"


class AlertOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """operator used to compare currentSpend with amount."""

    NONE = "None"
    EQUAL_TO = "EqualTo"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL_TO = "LessThanOrEqualTo"


class AlertSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source of alert."""

    PRESET = "Preset"
    USER = "User"


class AlertStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """alert status."""

    NONE = "None"
    ACTIVE = "Active"
    OVERRIDDEN = "Overridden"
    RESOLVED = "Resolved"
    DISMISSED = "Dismissed"


class AlertTimeGrainType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of timegrain cadence."""

    NONE = "None"
    MONTHLY = "Monthly"
    QUARTERLY = "Quarterly"
    ANNUALLY = "Annually"
    BILLING_MONTH = "BillingMonth"
    BILLING_QUARTER = "BillingQuarter"
    BILLING_ANNUAL = "BillingAnnual"


class AlertType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """type of alert."""

    BUDGET = "Budget"
    INVOICE = "Invoice"
    CREDIT = "Credit"
    QUOTA = "Quota"
    GENERAL = "General"
    X_CLOUD = "xCloud"
    BUDGET_FORECAST = "BudgetForecast"


class BenefitKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind/type of the benefit."""

    #: Benefit is IncludedQuantity.
    INCLUDED_QUANTITY = "IncludedQuantity"
    #: Benefit is Reservation.
    RESERVATION = "Reservation"
    #: Benefit is SavingsPlan.
    SAVINGS_PLAN = "SavingsPlan"


class ChartType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Chart type of the main view in Cost Analysis. Required."""

    AREA = "Area"
    LINE = "Line"
    STACKED_COLUMN = "StackedColumn"
    GROUPED_COLUMN = "GroupedColumn"
    TABLE = "Table"


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason why the given name is not available."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class CostDetailsDataFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data format of the report."""

    #: Csv data format.
    CSV_COST_DETAILS_DATA_FORMAT = "Csv"


class CostDetailsMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the detailed report. By default ActualCost is provided."""

    #: Actual cost data.
    ACTUAL_COST_COST_DETAILS_METRIC_TYPE = "ActualCost"
    #: Amortized cost data.
    AMORTIZED_COST_COST_DETAILS_METRIC_TYPE = "AmortizedCost"


class CostDetailsStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the cost details operation."""

    #: Operation is Completed.
    COMPLETED_COST_DETAILS_STATUS_TYPE = "Completed"
    #: Operation is Completed and no cost data found.
    NO_DATA_FOUND_COST_DETAILS_STATUS_TYPE = "NoDataFound"
    #: Operation Failed.
    FAILED_COST_DETAILS_STATUS_TYPE = "Failed"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DaysOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Days of Week."""

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"


class ExecutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The last known status of the export run."""

    QUEUED = "Queued"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"
    TIMEOUT = "Timeout"
    NEW_DATA_NOT_AVAILABLE = "NewDataNotAvailable"
    DATA_NOT_AVAILABLE = "DataNotAvailable"


class ExecutionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the export run."""

    ON_DEMAND = "OnDemand"
    SCHEDULED = "Scheduled"


class ExportType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the query."""

    USAGE = "Usage"
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"


class ExternalCloudProviderType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExternalCloudProviderType."""

    EXTERNAL_SUBSCRIPTIONS = "externalSubscriptions"
    EXTERNAL_BILLING_ACCOUNTS = "externalBillingAccounts"


class FileFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Destination of the view data. Currently only CSV format is supported."""

    CSV = "Csv"


class ForecastOperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator to use for comparison."""

    IN = "In"


class ForecastTimeframe(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The time frame for pulling data for the forecast."""

    CUSTOM = "Custom"


class ForecastType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the forecast."""

    USAGE = "Usage"
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"


class FormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The format of the export being delivered. Currently only 'Csv' is supported."""

    CSV = "Csv"


class FunctionName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the column to aggregate."""

    PRE_TAX_COST_USD = "PreTaxCostUSD"
    COST = "Cost"
    COST_USD = "CostUSD"
    PRE_TAX_COST = "PreTaxCost"


class FunctionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the aggregation function to use."""

    SUM = "Sum"


class GenerateDetailedCostReportMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the detailed report. By default ActualCost is provided."""

    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"


class Grain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Grain which corresponds to value."""

    #: Hourly grain corresponds to value per hour.
    HOURLY = "Hourly"
    #: Hourly grain corresponds to value per day.
    DAILY = "Daily"
    #: Hourly grain corresponds to value per month.
    MONTHLY = "Monthly"


class GrainParameter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GrainParameter."""

    #: Hourly grain corresponds to value per hour.
    HOURLY = "Hourly"
    #: Hourly grain corresponds to value per day.
    DAILY = "Daily"
    #: Hourly grain corresponds to value per month.
    MONTHLY = "Monthly"


class GranularityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The granularity of rows in the forecast."""

    DAILY = "Daily"


class KpiType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """KPI type (Forecast, Budget)."""

    FORECAST = "Forecast"
    BUDGET = "Budget"


class LookBackPeriod(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The number of days used to look back."""

    #: 7 days used to look back.
    LAST7_DAYS = "Last7Days"
    #: 30 days used to look back.
    LAST30_DAYS = "Last30Days"
    #: 60 days used to look back.
    LAST60_DAYS = "Last60Days"


class MetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric to use when displaying costs."""

    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"
    AHUB = "AHUB"


class OperationStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the long running operation."""

    RUNNING = "Running"
    COMPLETED = "Completed"
    FAILED = "Failed"


class OperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator to use for comparison."""

    IN = "In"
    CONTAINS = "Contains"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PivotType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data type to show in view."""

    DIMENSION = "Dimension"
    TAG_KEY = "TagKey"


class QueryColumnType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the column in the export."""

    TAG = "Tag"
    DIMENSION = "Dimension"


class QueryOperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operator to use for comparison."""

    IN = "In"


class RecurrenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The schedule recurrence."""

    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"
    ANNUALLY = "Annually"


class ReportConfigColumnType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the column in the report."""

    TAG = "Tag"
    DIMENSION = "Dimension"


class ReportConfigSortingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Direction of sort."""

    ASCENDING = "Ascending"
    DESCENDING = "Descending"


class ReportGranularityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The granularity of rows in the report."""

    DAILY = "Daily"
    MONTHLY = "Monthly"


class ReportOperationStatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the long running operation."""

    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"
    QUEUED = "Queued"
    NO_DATA_FOUND = "NoDataFound"
    READY_TO_DOWNLOAD = "ReadyToDownload"
    TIMED_OUT = "TimedOut"


class ReportTimeframeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The time frame for pulling data for the report. If custom, then a specific time period must be
    provided.
    """

    WEEK_TO_DATE = "WeekToDate"
    MONTH_TO_DATE = "MonthToDate"
    YEAR_TO_DATE = "YearToDate"
    CUSTOM = "Custom"


class ReportType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the report. Usage represents actual usage, forecast represents forecasted data and
    UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data
    can be differentiated based on dates.
    """

    USAGE = "Usage"


class ReservationReportSchema(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The CSV file from the reportUrl blob link consists of reservation usage data with the following
    schema at daily granularity.
    """

    INSTANCE_FLEXIBILITY_GROUP = "InstanceFlexibilityGroup"
    INSTANCE_FLEXIBILITY_RATIO = "InstanceFlexibilityRatio"
    INSTANCE_ID = "InstanceId"
    KIND = "Kind"
    RESERVATION_ID = "ReservationId"
    RESERVATION_ORDER_ID = "ReservationOrderId"
    RESERVED_HOURS = "ReservedHours"
    SKU_NAME = "SkuName"
    TOTAL_RESERVED_QUANTITY = "TotalReservedQuantity"
    USAGE_DATE = "UsageDate"
    USED_HOURS = "UsedHours"


class ScheduledActionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the scheduled action."""

    #: Cost analysis data will be emailed.
    EMAIL = "Email"
    #: Cost anomaly information will be emailed. Available only on subscription scope at daily
    #: frequency. If no anomaly is detected on the resource, an email won't be sent.
    INSIGHT_ALERT = "InsightAlert"


class ScheduledActionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the scheduled action."""

    #: Scheduled action is saved but will not be run.
    DISABLED = "Disabled"
    #: Scheduled action is saved and will be run.
    ENABLED = "Enabled"
    #: Scheduled action is expired.
    EXPIRED = "Expired"


class ScheduleFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Frequency of the schedule."""

    #: Cost analysis data will be emailed every day.
    DAILY = "Daily"
    #: Cost analysis data will be emailed every week.
    WEEKLY = "Weekly"
    #: Cost analysis data will be emailed every month.
    MONTHLY = "Monthly"


class Scope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of the recommendation scope."""

    #: Single scope recommendation.
    SINGLE = "Single"
    #: Shared scope recommendation.
    SHARED = "Shared"


class StatusType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the export's schedule. If 'Inactive', the export's schedule is paused."""

    ACTIVE = "Active"
    INACTIVE = "Inactive"


class Term(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Grain which corresponds to value."""

    #: Benefit term is 1 year.
    P1_Y = "P1Y"
    #: Benefit term is 3 years.
    P3_Y = "P3Y"


class TimeframeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The time frame for pulling data for the query. If custom, then a specific time period must be
    provided.
    """

    MONTH_TO_DATE = "MonthToDate"
    BILLING_MONTH_TO_DATE = "BillingMonthToDate"
    THE_LAST_MONTH = "TheLastMonth"
    THE_LAST_BILLING_MONTH = "TheLastBillingMonth"
    WEEK_TO_DATE = "WeekToDate"
    CUSTOM = "Custom"


class WeeksOfMonth(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Weeks of month."""

    FIRST = "First"
    SECOND = "Second"
    THIRD = "Third"
    FOURTH = "Fourth"
    LAST = "Last"
