# crispy-form-foundation documentation build configuration file, created by
# sphinx-quickstart on Sat Nov 15 20:21:48 2014.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

import sphinx_rtd_theme

from crispy_forms_foundation import __version__ as crispy_forms_foundation_version

# Push a dummy settings file required by Django that is imported in
# "crispy_forms_foundation.layout"
sys.path.append(os.path.join(os.path.dirname(__file__), '.'))
os.environ['DJANGO_SETTINGS_MODULE'] = 'dummy_settings'
from django.conf import settings

# -- Project information -----------------------------------------------------

project = 'crispy-form-foundation'
copyright = '2014, David THENON'
author = 'David THENON'

# The short X.Y version
version = crispy_forms_foundation_version
# The full version, including alpha/beta/rc tags
release = crispy_forms_foundation_version


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.viewcode',
    'sphinx.ext.napoleon',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# Use index.rst as root content doc file
master_doc = 'index'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes. Default to builtin theme "alabaster" if sphinx rtd
# is not available.
#
html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# -- Autodoc config---------- -------------------------------------------------

# Do not order autodoc contents by alphabetical, keep to the source order
autodoc_member_order = "bysource"
