% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSingleCellExperiment.R
\name{readSingleCellExperiment}
\alias{readSingleCellExperiment}
\alias{loadSingleCellExperiment}
\title{Read a SingleCellExperiment from disk}
\usage{
readSingleCellExperiment(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created using the \code{\link{saveObject}} method for \linkS4class{SingleCellExperiment} objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments passed to \code{\link{readRangedSummarizedExperiment}} and internal \code{\link{altReadObject}} calls.}
}
\value{
A \linkS4class{SingleCellExperiment} object.
}
\description{
Read a \linkS4class{SingleCellExperiment} object from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
# Mocking up an SCE:
mat <- matrix(rpois(10000, 10), ncol=10)
colnames(mat) <- letters[1:10]
rownames(mat) <- sprintf("GENE_\%i", seq_len(nrow(mat)))

se <- SingleCellExperiment(list(counts=mat))
se$stuff <- LETTERS[1:10]
se$blah <- runif(10)
reducedDims(se) <- list(
    PCA=matrix(rnorm(ncol(se)*10), ncol=10),
    TSNE=matrix(rnorm(ncol(se)*2), ncol=2)
)
altExps(se) <- list(spikes=SummarizedExperiment(list(counts=mat[1:2,])))

# Staging it: 
tmp <- tempfile()
saveObject(se, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,SingleCellExperiment-method}"}, to save the SingleCellExperiment to disk.
}
\author{
Aaron Lun
}
