% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC.samplemean.R
\name{MC.samplemean}
\alias{MC.samplemean}
\title{Sample Mean Monte Carlo integration}
\usage{
MC.samplemean(
  FUN = function(x) x - x^2,
  n = ani.options("nmax"),
  col.rect = c("gray", "black"),
  adj.x = TRUE,
  ...
)
}
\arguments{
\item{FUN}{the function to be integrated}

\item{n}{number of points to be sampled from the Uniform(0, 1) distribution}

\item{col.rect}{colors of rectangles (for the past rectangles and the current
one)}

\item{adj.x}{should the locations of rectangles on the x-axis be adjusted?
If \code{TRUE}, the rectangles will be laid side by side and it is
informative for us to assess the total area of the rectangles, otherwise
the rectangles will be laid at their exact locations.}

\item{\dots}{other arguments passed to \code{\link{rect}}}
}
\value{
A list containing \item{x}{ the Uniform random numbers } \item{y}{
  function values evaluated at \code{x} } \item{n}{ number of points drawn
  from the Uniform distribtion } \item{est}{ the estimated value of the
  integral }
}
\description{
Integrate a function from 0 to 1 using the Sample Mean Monte Carlo algorithm
}
\details{
\emph{Sample Mean Monte Carlo} integration can compute

\deqn{I=\int_0^1 f(x) dx}

by drawing random numbers \eqn{x_i} from Uniform(0, 1) distribution and
average the values of \eqn{f(x_i)}. As \eqn{n} goes to infinity, the sample
mean will approach to the expectation of \eqn{f(X)} by Law of Large Numbers.

The height of the \eqn{i}-th rectangle in the animation is \eqn{f(x_i)} and
the width is \eqn{1/n}, so the total area of all the rectangles is \eqn{\sum
f(x_i) 1/n}, which is just the sample mean. We can compare the area of
rectangles to the curve to see how close is the area to the real integral.
}
\note{
This function is for demonstration purpose only; the integral might be
  very inaccurate when \code{n} is small.

  \code{ani.options('nmax')} specifies the maximum number of trials.
}
\references{
Examples at \url{https://yihui.org/animation/example/mc-samplemean/}
}
\seealso{
\code{\link{integrate}}, \code{\link{MC.hitormiss}}
}
\author{
Yihui Xie
}
