% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{indexOf}
\alias{indexOf}
\title{Find the index of timestamps in the time series}
\usage{
indexOf(x, y, method = "constant")
}
\arguments{
\item{x}{Vector of \code{character}, \code{POSIXt} or \code{Date} values to find indices
for, or a numeric vector.}

\item{y}{\link{CFTime} instance.}

\item{method}{Single value of "constant" or "linear". If \code{"constant"} or when
bounds are set on argument \code{y}, return the index value for each match. If
\code{"linear"}, return the index value with any fractional value.}
}
\value{
A numeric vector giving indices into the "time" dimension of the
data set associated with \code{y} for the values of \code{x}. If there is at least 1
valid index, then attribute "CFTime" contains an instance of \code{CFTime} that
describes the dimension of filtering the data set associated with \code{y} with
the result of this function, excluding any \code{NA}, \code{0} and
\code{.Machine$integer.max} values.
}
\description{
Find the index in the time series for each timestamp given in argument \code{x}.
Values of \code{x} that are before the earliest value in \code{y} will be returned as
\code{0}; values of \code{x} that are after the latest values in \code{y} will be returned
as \code{.Machine$integer.max}. Alternatively, when \code{x} is a numeric vector of
index values, return the valid indices of the same vector, with the side
effect being the attribute "CFTime" associated with the result.
}
\details{
Timestamps can be provided as vectors of character strings, \code{POSIXct} or
\code{Date.}

Matching also returns index values for timestamps that fall between two
elements of the time series - this can lead to surprising results when time
series elements are positioned in the middle of an interval (as the CF
Metadata Conventions instruct us to "reasonably assume"): a time series of
days in January would be encoded in a netCDF file as
\code{c("2024-01-01 12:00:00", "2024-01-02 12:00:00", "2024-01-03 12:00:00", ...)}
so \code{x <- c("2024-01-01", "2024-01-02", "2024-01-03")} would result in
\verb{(NA, 1, 2)} (or \verb{(NA, 1.5, 2.5)} with \code{method = "linear"}) because the date
values in \code{x} are at midnight. This situation is easily avoided by ensuring
that \code{y} has bounds set (use \code{bounds(y) <- TRUE} as a proximate solution if
bounds are not stored in the netCDF file). See the Examples.

If bounds are set, the indices are taken from those bounds. Returned indices
may fall in between bounds if the latter are not contiguous, with the
exception of the extreme values in \code{x}.

Values of \code{x} that are not valid timestamps according to the calendar of \code{y}
will be returned as \code{NA}.

\code{x} can also be a numeric vector of index values, in which case the valid
values in \code{x} are returned. If negative values are passed, the positive
counterparts will be excluded and then the remainder returned. Positive and
negative values may not be mixed. Using a numeric vector has the side effect
that the result has the attribute "CFTime" describing the temporal dimension
of the slice. If index values outside of the range of \code{y} (\code{1:length(y)}) are
provided, an error will be thrown.
}
\examples{
cf <- CFtime("days since 2020-01-01", "360_day", 1440:1799 + 0.5)
as_timestamp(cf)[1:3]
x <- c("2024-01-01", "2024-01-02", "2024-01-03")
indexOf(x, cf)
indexOf(x, cf, method = "linear")

bounds(cf) <- TRUE
indexOf(x, cf)

# Non-existent calendar day in a `360_day` calendar
x <- c("2024-03-30", "2024-03-31", "2024-04-01")
indexOf(x, cf)

# Numeric x
indexOf(c(29, 30, 31), cf)
}
