% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothness.R
\name{smoothness}
\alias{smoothness}
\title{Quantify the smoothness of a vector}
\usage{
smoothness(x, method = "cor", lag = 1, iterations = NULL, ...)
}
\arguments{
\item{x}{Numeric vector (similar to a time series).}

\item{method}{Can be "diff" (the standard deviation of the standardized
differences) or "cor" (default, lag-one autocorrelation).}

\item{lag}{An integer indicating which lag to use. If less than 1, will be
interpreted as expressed in percentage of the length of the vector.}

\item{iterations}{The number of bootstrap replicates for computing standard
errors. If \code{NULL} (default), parametric standard errors are computed.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
Value of smoothness.
}
\description{
Quantify the smoothness of a vector
}
\examples{
x <- (-10:10)^3 + rnorm(21, 0, 100)
plot(x)
smoothness(x, method = "cor")
smoothness(x, method = "diff")
}
\references{
https://stats.stackexchange.com/questions/24607/how-to-measure-smoothness-of-a-time-series-in-r
}
