% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_common_language.R
\name{diff_to_cles}
\alias{diff_to_cles}
\alias{d_to_p_superiority}
\alias{d_to_cles}
\alias{rb_to_cles}
\alias{rb_to_p_superiority}
\alias{rb_to_vda}
\alias{d_to_u2}
\alias{d_to_u1}
\alias{d_to_u3}
\alias{d_to_overlap}
\alias{rb_to_wmw_odds}
\title{Convert Standardized Differences to Common Language Effect Sizes}
\usage{
d_to_p_superiority(d)

rb_to_p_superiority(rb)

rb_to_vda(rb)

d_to_u2(d)

d_to_u1(d)

d_to_u3(d)

d_to_overlap(d)

rb_to_wmw_odds(rb)
}
\arguments{
\item{d, rb}{A numeric vector of Cohen's d / rank-biserial correlation \emph{or}
the output from \code{\link[=cohens_d]{cohens_d()}} / \code{\link[=rank_biserial]{rank_biserial()}}.}
}
\value{
A list of \verb{Cohen's U3}, \code{Overlap}, \code{Pr(superiority)}, a
numeric vector of \code{Pr(superiority)}, or a data frame, depending
on the input.
}
\description{
Convert Standardized Differences to Common Language Effect Sizes
}
\details{
This function use the following formulae for Cohen's \emph{d}:
\deqn{Pr(superiority) = \Phi(d/\sqrt{2})}{Pr(superiority) = pnorm(d / sqrt(2))}
\cr
\deqn{\textrm{Cohen's } U_3 = \Phi(d)}{U3 = pnorm(d)}
\cr
\deqn{\textrm{Cohen's } U_2 = \Phi(|d|/2)}{U2 = pnorm(abs(d)/2)}
\cr
\deqn{\textrm{Cohen's } U_1 = (2\times U_2 - 1)/U_2}{U1 = (2 * U2 - 1) / U2}
\cr
\deqn{Overlap = 2 \times \Phi(-|d|/2)}{Overlap = 2 * pnorm(-abs(d) / 2)}
\cr
And the following for the rank-biserial correlation:
\deqn{Pr(superiority) = (r_{rb} + 1)/2}{Pr(superiority) = (rb + 1)/2}
\cr
\eqn{WMW_{Odds} = Pr(superiority) / (1 - Pr(superiority))}
}
\note{
For \emph{d}, these calculations assume that the populations have equal variance
and are normally distributed.

Vargha and Delaney's \emph{A} is an alias for the non-parametric \emph{probability of
superiority}.
}
\references{
\itemize{
\item Cohen, J. (1977). Statistical power analysis for the behavioral sciences.
New York: Routledge.
\item Reiser, B., & Faraggi, D. (1999). Confidence intervals for the overlapping
coefficient: the normal equal variance case. Journal of the Royal Statistical
Society, 48(3), 413-418.
\item Ruscio, J. (2008). A probability-based measure of effect size: robustness
to base rates and other factors. Psychological methods, 13(1), 19–30.
}
}
\seealso{
\code{\link[=cohens_u3]{cohens_u3()}} for descriptions of the effect sizes (also,
\code{\link[=cohens_d]{cohens_d()}}, \code{\link[=rank_biserial]{rank_biserial()}}).

Other convert between effect sizes: 
\code{\link{d_to_r}()},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()},
\code{\link{oddsratio_to_riskratio}()}
}
\concept{convert between effect sizes}
