% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-components.R
\name{transition_components}
\alias{transition_components}
\title{Transition individual components through their own lifecycle}
\usage{
transition_components(
  time,
  range = NULL,
  enter_length = NULL,
  exit_length = NULL,
  id
)
}
\arguments{
\item{time}{The unquoted name of the column holding the time for each state
of the components}

\item{range}{The range the animation should span. Defaults to the range of
time plus enter and exit length}

\item{enter_length, exit_length}{How long time should be spend on enter and
exit transitions. Defaults to 0}

\item{id}{\strong{Deprecated}}
}
\description{
This transition allows individual visual components to define their own
"life-cycle". This means that the final animation will not have any common
"state" and "transition" phase as any component can be moving or static at
any point in time.
}
\section{Label variables}{

\code{transition_components} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{frame_time} gives the time that the current frame corresponds to
}
}

\section{Object permanence}{

\code{transition_components} uses the group aesthetic of each layer to identify
which rows in the input data correspond to the same graphic element and will
therefore define stages in time that the element will animate through. The
group aesthetic, if not set, will be calculated from the interaction of all
discrete aesthetics in the layer (excluding \code{label}), so it is often better
to set it explicitly when animating, to make sure your data is interpreted in
the right way. If the group aesthetic is not set, and no discrete aesthetics
exists then all rows will have the same group.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
data <- data.frame(
  x = runif(10),
  y = runif(10),
  size = sample(1:3, 10, TRUE),
  time = c(1, 4, 6, 7, 9, 6, 7, 8, 9, 10),
  id = rep(1:2, each = 5)
)

anim <- ggplot(data, aes(x, y, group = id, size = size)) +
  geom_point() +
  transition_components(time)

# By default the time range is set to the range of the time variable (plus
# any enter and exit length), but this can be overwritten
anim2 <- ggplot(data, aes(x, y, group = id, size = size)) +
  geom_point() +
  transition_components(time, range = c(4, 8))

# If you are using any enter/exit functions you need to give them some time
anim3 <- ggplot(data, aes(x, y, group = id, size = size)) +
  geom_point() +
  transition_components(time, enter_length = 2, exit_length = 2) +
  enter_grow() +
  exit_fade()

}
\seealso{
Other transitions: 
\code{\link{transition_events}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_manual}()},
\code{\link{transition_null}()},
\code{\link{transition_reveal}()},
\code{\link{transition_states}()},
\code{\link{transition_time}()}
}
\concept{transitions}
