% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-quasirandom.R
\name{position_quasirandom}
\alias{position_quasirandom}
\title{Arrange points using quasirandom noise to avoid overplotting}
\usage{
position_quasirandom(
  method = "quasirandom",
  width = NULL,
  varwidth = FALSE,
  bandwidth = 0.5,
  nbins = NULL,
  dodge.width = 0,
  groupOnX = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{method}{the method used for distributing points
(quasirandom, pseudorandom, smiley, maxout, frowney, minout, tukey, tukeyDense).
See \code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} for the details of each method.}

\item{width}{the maximum amount of spread (default: 0.4)}

\item{varwidth}{vary the width by the relative size of each group}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density
(has little effect with quasirandom/random distribution)}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} No longer needed.}

\item{na.rm}{if FALSE, the default, missing values are removed with a warning.
If TRUE, missing values are silently removed.}
}
\description{
Arrange points using quasirandom noise to avoid overplotting
}
\seealso{
\code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}}, \code{\link[=geom_quasirandom]{geom_quasirandom()}}

Other position adjustments: 
\code{\link{offset_beeswarm}()},
\code{\link{position_beeswarm}()}
}
\concept{position adjustments}
