% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{geom_voronoi}
\alias{geom_voronoi}
\alias{geom_delaunay}
\alias{geom_voronoi_tile}
\alias{geom_voronoi_segment}
\alias{geom_delaunay_tile}
\alias{geom_delaunay_segment}
\alias{geom_delaunay_segment2}
\alias{stat_delvor_summary}
\title{Voronoi tesselation and delaunay triangulation}
\usage{
geom_voronoi_tile(
  mapping = NULL,
  data = NULL,
  stat = "voronoi_tile",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  max.radius = NULL,
  normalize = FALSE,
  asp.ratio = 1,
  expand = 0,
  radius = 0,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_voronoi_segment(
  mapping = NULL,
  data = NULL,
  stat = "voronoi_segment",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  normalize = FALSE,
  asp.ratio = 1,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_delaunay_tile(
  mapping = NULL,
  data = NULL,
  stat = "delaunay_tile",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  normalize = FALSE,
  asp.ratio = 1,
  expand = 0,
  radius = 0,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_delaunay_segment(
  mapping = NULL,
  data = NULL,
  stat = "delaunay_segment",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  normalize = FALSE,
  asp.ratio = 1,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_delaunay_segment2(
  mapping = NULL,
  data = NULL,
  stat = "delaunay_segment2",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  normalize = FALSE,
  asp.ratio = 1,
  n = 100,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_delvor_summary(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  na.rm = FALSE,
  bound = NULL,
  eps = 1e-09,
  normalize = FALSE,
  asp.ratio = 1,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{bound}{The bounding rectangle for the tesselation or a custom polygon
to clip the tesselation to. Defaults to \code{NULL} which creates a rectangle
expanded 10\\% in all directions. If supplied as a bounding box it should be a
vector giving the bounds in the following order: xmin, xmax, ymin, ymax. If
supplied as a polygon it should either be a 2-column matrix or a data.frame
containing an \code{x} and \code{y} column.}

\item{eps}{A value of epsilon used in testing whether a quantity is zero,
mainly in the context of whether points are collinear. If anomalous errors
arise, it is possible that these may averted by adjusting the value of eps
upward or downward.}

\item{max.radius}{The maximum distance a tile can extend from the point of
origin. Will in effect clip each tile to a circle centered at the point with
the given radius. If \code{normalize = TRUE} the radius will be given relative to
the normalized values}

\item{normalize}{Should coordinates be normalized prior to calculations. If
\code{x} and \code{y} are in wildly different ranges it can lead to
tesselation and triangulation that seems off when plotted without
\code{\link[ggplot2:coord_fixed]{ggplot2::coord_fixed()}}. Normalization of coordinates solves this.
The coordinates are transformed back after calculations.}

\item{asp.ratio}{If \code{normalize = TRUE} the x values will be multiplied by this
amount after normalization.}

\item{expand}{A numeric or unit vector of length one, specifying the
expansion amount. Negative values will result in contraction instead. If the
value is given as a numeric it will be understood as a proportion of the
plot area width.}

\item{radius}{As \code{expand} but specifying the corner radius.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{n}{The number of points to create for each segment}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}
}
\description{
This set of geoms and stats allows you to display voronoi tesselation and
delaunay triangulation, both as polygons and as line segments. Furthermore
it lets you augment your point data with related summary statistics. The
computations are based on the \code{\link[deldir:deldir]{deldir::deldir()}} package.
}
\section{Aesthetics}{

geom_voronoi_tile and geom_delaunay_tile understand the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item alpha
\item color
\item fill
\item linetype
\item size
}

geom_voronoi_segment, geom_delaunay_segment, and geom_delaunay_segment2
understand the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item alpha
\item color
\item linetype
\item size
}
}

\section{Computed variables}{

stat_delvor_summary computes the following variables:
\describe{
\item{x, y}{If \code{switch.centroid = TRUE} this will be the coordinates for
the voronoi tile centroid, otherwise it is the original point}
\item{xcent, ycent}{If \code{switch.centroid = FALSE} this will be the
coordinates for the voronoi tile centroid, otherwise it will be \code{NULL}}
\item{xorig, yorig}{If \code{switch.centroid = TRUE} this will be the
coordinates for the original point, otherwise it will be \code{NULL}}
\item{ntri}{Number of triangles emanating from the point}
\item{triarea}{The total area of triangles emanating from the point divided
by 3}
\item{triprop}{\code{triarea} divided by the sum of the area of all
triangles}
\item{nsides}{Number of sides on the voronoi tile associated with the point}
\item{nedges}{Number of sides of the associated voronoi tile that is part of
the bounding box}
\item{vorarea}{The area of the voronoi tile associated with the point}
\item{vorprop}{\code{vorarea} divided by the sum of all voronoi tiles}
}
}

\examples{
\dontshow{if (requireNamespace("deldir", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Voronoi
# You usually wants all points to take part in the same tesselation so set
# the group aesthetic to a constant (-1L is just a convention)
ggplot(iris, aes(Sepal.Length, Sepal.Width, group = -1L)) +
  geom_voronoi_tile(aes(fill = Species)) +
  geom_voronoi_segment() +
  geom_text(aes(label = after_stat(nsides), size = after_stat(vorarea)),
    stat = 'delvor_summary', switch.centroid = TRUE
  )

# Difference of normalize = TRUE (segment layer is calculated without
# normalisation)
ggplot(iris, aes(Sepal.Length, Sepal.Width, group = -1L)) +
  geom_voronoi_tile(aes(fill = Species), normalize = TRUE) +
  geom_voronoi_segment()

# Set a max radius
ggplot(iris, aes(Sepal.Length, Sepal.Width, group = -1L)) +
  geom_voronoi_tile(aes(fill = Species), colour = 'black', max.radius = 0.25)

# Set custom bounding polygon
triangle <- cbind(c(3, 9, 6), c(1, 1, 6))
ggplot(iris, aes(Sepal.Length, Sepal.Width, group = -1L)) +
  geom_voronoi_tile(aes(fill = Species), colour = 'black', bound = triangle)

# Use geom_shape functionality to round corners etc
ggplot(iris, aes(Sepal.Length, Sepal.Width, group = -1L)) +
  geom_voronoi_tile(aes(fill = Species), colour = 'black',
                    expand = unit(-.5, 'mm'), radius = unit(2, 'mm'))

# Delaunay triangles
ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_delaunay_tile(alpha = 0.3, colour = 'black')

# Use geom_delauney_segment2 to interpolate aestetics between end points
ggplot(iris, aes(Sepal.Length, Sepal.Width)) +
  geom_delaunay_segment2(aes(colour = Species, group = -1), size = 2,
                         lineend = 'round')
\dontshow{\}) # examplesIf}
}
