% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_get.R
\name{drive_get}
\alias{drive_get}
\title{Get Drive files by path or id}
\usage{
drive_get(
  path = NULL,
  id = NULL,
  shared_drive = NULL,
  corpus = NULL,
  verbose = deprecated(),
  team_drive = deprecated()
)
}
\arguments{
\item{path}{Character vector of path(s) to get. Use a trailing slash to
indicate explicitly that a path is a folder, which can disambiguate if
there is a file of the same name (yes this is possible on Drive!). If
\code{path} appears to contain Drive URLs or is explicitly marked with
\code{\link[=as_id]{as_id()}}, it is treated as if it was provided via the \code{id} argument.}

\item{id}{Character vector of Drive file ids or URLs (it is first processed
with \code{\link[=as_id]{as_id()}}). If both \code{path} and \code{id} are non-\code{NULL}, \code{id} is silently
ignored.}

\item{shared_drive}{Anything that identifies one specific shared drive: its
name, its id or URL marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}. The value
provided to \code{shared_drive} is pre-processed with \code{\link[=as_shared_drive]{as_shared_drive()}}. Read
more about \link[=shared_drives]{shared drives}.}

\item{corpus}{Character, specifying which collections of items to search.
Relevant to those who work with shared drives and/or Google Workspace
domains. If specified, must be one of \code{"user"}, \code{"drive"} (requires that
\code{shared_drive} also be specified), \code{"allDrives"}, or \code{"domain"}. Read more
about \link[=shared_drives]{shared drives}.}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This logical argument to
individual googledrive functions is deprecated. To globally suppress
googledrive messaging, use \code{options(googledrive_quiet = TRUE)} (the default
behaviour is to emit informational messages). To suppress messaging in a
more limited way, use the helpers \code{\link[=local_drive_quiet]{local_drive_quiet()}} or
\code{\link[=with_drive_quiet]{with_drive_quiet()}}.}

\item{team_drive}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Google Drive and the
Drive API have replaced Team Drives with shared drives.}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per file.
If the target files were specified via \code{path},
there will be a \code{path} column.
}
\description{
Retrieves metadata for files specified via \code{path} or via file \code{id}. This
function is quite straightforward if you specify files by \code{id}. But there are
some important considerations when you specify your target files by \code{path}.
See below for more. If the target files are specified via \code{path}, the
returned \code{\link{dribble}} will include a \code{path} column.
}
\section{Getting by \code{path}}{


Google Drive does NOT behave like your local file system! File and folder
names need not be unique, even at a given level of the hierarchy. This
means that a single path can describe multiple files (or 0 or exactly 1).

A single file can also be compatible with multiple paths, i.e. one path
could be more specific than the other. A file located at \verb{~/alfa/bravo} can
be found as \code{bravo}, \code{alfa/bravo}, and \verb{~/alfa/bravo}. If all 3 of those
were included in the input \code{path}, they would be represented by a
\strong{single} row in the output.

It's best to think of \code{drive_get()} as a setwise operation when using file
paths. Do not assume that the \code{i}-th input path corresponds to row \code{i} in
the output (although it often does!). If there's not a 1-to-1 relationship
between the input and output, this will be announced in a message.

\code{drive_get()} performs just enough path resolution to uniquely identify a
file compatible with each input \code{path}, for all \code{path}s at once. If you
absolutely want the full canonical path, run the output of \code{drive_get()}
through \code{\link[=drive_reveal]{drive_reveal(d, "path")}}`.
}

\section{Files that you don't own}{


If you want to get a file via \code{path} and it's not necessarily on your My
Drive, you may need to specify the \code{shared_drive} or \code{corpus} arguments to
search other collections of items. Read more about \link[=shared_drives]{shared drives}.
}

\examples{
\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get info about your "My Drive" root folder
drive_get("~/")
# the API reserves the file id "root" for your root folder
drive_get(id = "root")
drive_get(id = "root") \%>\% drive_reveal("path")

# set up some files to get by path
alfalfa <- drive_mkdir("alfalfa")
broccoli <- drive_upload(
  drive_example_local("chicken.txt"),
  name = "broccoli", path = alfalfa
)
drive_get("broccoli")
drive_get("alfalfa/broccoli")
drive_get("~/alfalfa/broccoli")
drive_get(c("broccoli", "alfalfa/", "~/alfalfa/broccoli"))

# clean up
drive_rm(alfalfa)

\dontrun{
# The examples below are indicative of correct syntax.
# But note these will generally result in an error or a
# 0-row dribble, unless you replace the inputs with paths
# or file ids that exist in your Drive.

# multiple names
drive_get(c("abc", "def"))

# multiple names, one of which must be a folder
drive_get(c("abc", "def/"))

# query by file id(s)
drive_get(id = "abcdefgeh123456789")
drive_get(as_id("abcdefgeh123456789"))
drive_get(id = c("abcdefgh123456789", "jklmnopq123456789"))

# apply to a browser URL for, e.g., a Google Sheet
my_url <- "https://docs.google.com/spreadsheets/d/FILE_ID/edit#gid=SHEET_ID"
drive_get(my_url)
drive_get(as_id(my_url))
drive_get(id = my_url)

# access the shared drive named "foo"
# shared_drive params must be specified if getting by path
foo <- shared_drive_get("foo")
drive_get(c("this.jpg", "that-file"), shared_drive = foo)
# shared_drive params are not necessary if getting by id
drive_get(as_id("123456789"))

# search all shared drives and other files user has accessed
drive_get(c("this.jpg", "that-file"), corpus = "allDrives")
}
\dontshow{\}) # examplesIf}
}
\seealso{
To add path information to any \code{\link{dribble}} that lacks it, use
\code{\link[=drive_reveal]{drive_reveal(d, "path")}}. To list the contents of a
folder, use \code{\link[=drive_ls]{drive_ls()}}. For general searching, use \code{\link[=drive_find]{drive_find()}}.

Wraps the \code{files.get} endpoint and, if you specify files by name or
path, also calls \code{files.list}:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/reference/files/get}
\item \url{https://developers.google.com/drive/api/v3/reference/files/list}
}
}
