% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap.lvm}
\alias{bootstrap.lvm}
\alias{bootstrap.lvmfit}
\title{Calculate bootstrap estimates of a lvm object}
\usage{
\method{bootstrap}{lvm}(x,R=100,data,fun=NULL,control=list(),
                          p, parametric=FALSE, bollenstine=FALSE,
                          constraints=TRUE,sd=FALSE,messages=lava.options()$messages,
                          parallel=lava.options()$parallel,
                          mc.cores=NULL,
                          ...)

\method{bootstrap}{lvmfit}(x,R=100,data=model.frame(x),
                             control=list(start=coef(x)),
                             p=coef(x), parametric=FALSE, bollenstine=FALSE,
                             estimator=x$estimator,weights=Weights(x),...)
}
\arguments{
\item{x}{\code{lvm}-object.}

\item{R}{Number of bootstrap samples}

\item{data}{The data to resample from}

\item{fun}{Optional function of the (bootstrapped) model-fit defining the
statistic of interest}

\item{control}{Options to the optimization routine}

\item{p}{Parameter vector of the null model for the parametric bootstrap}

\item{parametric}{If TRUE a parametric bootstrap is calculated. If FALSE a
non-parametric (row-sampling) bootstrap is computed.}

\item{bollenstine}{Bollen-Stine transformation (non-parametric bootstrap) for bootstrap hypothesis testing.}

\item{constraints}{Logical indicating whether non-linear parameter
constraints should be included in the bootstrap procedure}

\item{sd}{Logical indicating whether standard error estimates should be
included in the bootstrap procedure}

\item{messages}{Control amount of messages printed}

\item{parallel}{If TRUE parallel backend will be used}

\item{mc.cores}{Number of threads (if NULL foreach::foreach will be used, otherwise parallel::mclapply)}

\item{\dots}{Additional arguments, e.g. choice of estimator.}

\item{estimator}{String definining estimator, e.g. 'gaussian' (see
\code{estimator})}

\item{weights}{Optional weights matrix used by \code{estimator}}
}
\value{
A \code{bootstrap.lvm} object.
}
\description{
Draws non-parametric bootstrap samples
}
\examples{
m <- lvm(y~x)
d <- sim(m,100)
e <- estimate(lvm(y~x), data=d)
\donttest{ ## Reduce Ex.Timings
B <- bootstrap(e,R=50,parallel=FALSE)
B
}
}
\seealso{
\code{\link{confint.lvmfit}}
}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{regression}
