% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws-index.R
\name{draws-index}
\alias{draws-index}
\alias{iteration_ids}
\alias{chain_ids}
\alias{draw_ids}
\alias{niterations}
\alias{nchains}
\alias{ndraws}
\title{Index \code{draws} objects}
\usage{
iteration_ids(x)

chain_ids(x)

draw_ids(x)

niterations(x)

nchains(x)

ndraws(x)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}
}
\value{
For \code{iteration_ids()}, \code{chain_ids()}, and \code{draw_ids()}, an integer vector.

For \code{niterations()}, \code{nchains()}, and \code{ndraws()}, a scalar integer.
}
\description{
Index iterations, chains, and draws of \code{\link{draws}} objects.
}
\details{
The methods \code{iteration_ids()}, \code{chain_ids()}, and \code{draw_ids()} return
vectors of all iterations, chains, and draws, respectively. In
contrast, the methods \code{niterations()}, \code{nchains()}, and
\code{ndraws()} return the number of variables, iterations, chains, and draws,
respectively.
}
\examples{
x <- example_draws()

iteration_ids(x)
niterations(x)

chain_ids(x)
nchains(x)

draw_ids(x)
ndraws(x)

}
\seealso{
\code{\link{variables}}, \code{\link{rename_variables}}
}
