% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{step_corr}
\alias{step_corr}
\title{High Correlation Filter}
\usage{
step_corr(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  threshold = 0.9,
  use = "pairwise.complete.obs",
  method = "pearson",
  removals = NULL,
  skip = FALSE,
  id = rand_id("corr")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{threshold}{A value for the threshold of absolute
correlation values. The step will try to remove the minimum
number of columns so that all the resulting absolute
correlations are less than this value.}

\item{use}{A character string for the \code{use} argument to
the \code{\link[stats:cor]{stats::cor()}} function.}

\item{method}{A character string for the \code{method} argument
to the \code{\link[stats:cor]{stats::cor()}} function.}

\item{removals}{A character string that contains the names of
columns that should be removed. These values are not determined
until \code{\link[=prep]{prep()}} is called.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_corr} creates a \emph{specification} of a recipe
step that will potentially remove variables that have large
absolute correlations with other variables.
}
\details{
This step can potentially remove columns from the data set. This may
cause issues for subsequent steps in your recipe if the missing columns are
specifically referenced by name. To avoid this, see the advice in the
\emph{Tips for saving recipes and filtering columns} section of \link{selections}.

This step attempts to remove variables to keep the
largest absolute correlation between the variables less than
\code{threshold}.

When a column has a single unique value, that column will be
excluded from the correlation analysis. Also, if the data set
has sporadic missing values (and an inappropriate value of \code{use}
is chosen), some columns will also be excluded from the filter.

The arguments \code{use} and \code{method} don't take effect if case weights
are used in the recipe.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with column
\code{terms} (the columns that will be removed) is returned.
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

set.seed(3535)
biomass$duplicate <- biomass$carbon + rnorm(nrow(biomass))

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur + duplicate,
  data = biomass_tr
)

corr_filter <- rec \%>\%
  step_corr(all_numeric_predictors(), threshold = .5)

filter_obj <- prep(corr_filter, training = biomass_tr)

filtered_te <- bake(filter_obj, biomass_te)
round(abs(cor(biomass_tr[, c(3:7, 9)])), 2)
round(abs(cor(filtered_te)), 2)

tidy(corr_filter, number = 1)
tidy(filter_obj, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other variable filter steps: 
\code{\link{step_filter_missing}()},
\code{\link{step_lincomb}()},
\code{\link{step_nzv}()},
\code{\link{step_rm}()},
\code{\link{step_select}()},
\code{\link{step_zv}()}
}
\author{
Original R code for filtering algorithm by Dong Li,
modified by Max Kuhn. Contributions by Reynald Lescarbeau (for
original in \code{caret} package). Max Kuhn for the \code{step}
function.
}
\concept{variable filter steps}
