% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{SCTResults}
\alias{SCTResults}
\alias{SCTResults<-}
\alias{SCTResults.SCTModel}
\alias{SCTResults<-.SCTModel}
\alias{SCTResults.SCTAssay}
\alias{SCTResults<-.SCTAssay}
\alias{SCTResults.Seurat}
\title{Get SCT results from an Assay}
\usage{
SCTResults(object, ...)

SCTResults(object, ...) <- value

\method{SCTResults}{SCTModel}(object, slot, ...)

\method{SCTResults}{SCTModel}(object, slot, ...) <- value

\method{SCTResults}{SCTAssay}(object, slot, model = NULL, ...)

\method{SCTResults}{SCTAssay}(object, slot, model = NULL, ...) <- value

\method{SCTResults}{Seurat}(object, assay = "SCT", slot, model = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods (not used)}

\item{value}{new data to set}

\item{slot}{Which slot to pull the SCT results from}

\item{model}{Name of SCModel to pull result from. Available names can be
retrieved with \code{levels}.}

\item{assay}{Assay in the Seurat object to pull from}
}
\value{
Returns the value present in the requested slot for the requested
group. If group is not specified, returns a list of slot results for each
group unless there is only one group present (in which case it just returns
the slot directly).
}
\description{
Pull the \code{\link{SCTResults}} information from an \code{\link{SCTAssay}}
object.
}
