% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{partition}
\alias{partition}
\alias{bind}
\alias{yank}
\title{Separate a big \code{skim_df} into smaller data frames, by type.}
\usage{
partition(data)

bind(data)

yank(data, skim_type)
}
\arguments{
\item{data}{A \code{skim_df}.}

\item{skim_type}{A character scalar. The subtable to extract from a
\code{skim_df}.}
}
\value{
A \code{skim_list} of \code{skim_df}'s, by type.
}
\description{
The data frames produced by \code{\link[=skim]{skim()}} are wide and sparse, filled with
columns that are mostly \code{NA}. For that reason, it can be convenient to
work with "by type" subsets of the original data frame. These smaller
subsets have their \code{NA} columns removed.
}
\details{
\code{partition()} creates a list of smaller \code{skim_df} data frames. Each entry
in the list is a data type from the original \code{skim_df}. The inverse of
\code{partition()} is \code{bind()}, which takes the list and produces the original
\code{skim_df}. While \code{partition()} keeps all of the subtables as list entries,
\code{yank()} gives you a single subtable for a data type.
}
\section{Functions}{
\itemize{
\item \code{bind()}: The inverse of a \code{partition()}. Rebuild the original
\code{skim_df}.

\item \code{yank()}: Extract a subtable from a \code{skim_df} with a particular
type.

}}
\examples{
# Create a wide skimmed data frame (a skim_df)
skimmed <- skim(iris)

# Separate into a list of subtables by type
separate <- partition(skimmed)

# Put back together
identical(bind(separate), skimmed)
# > TRUE

# Alternatively, get the subtable of a particular type
yank(skimmed, "factor")
}
