// This file is part of Desktop App Toolkit,
// a set of libraries for developing nice desktop applications.
//
// For license and copyright information please follow this link:
// https://github.com/desktop-app/legal/blob/master/LEGAL
//
#pragma once

namespace Ui {

class DynamicImage {
public:
	virtual ~DynamicImage() = default;

	[[nodiscard]] virtual std::shared_ptr<DynamicImage> clone() = 0;

	[[nodiscard]] virtual QImage image(int size) = 0;
	virtual void subscribeToUpdates(Fn<void()> callback) = 0;
};

} // namespace Ui
